
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Contains a choice of functions to update and Order including Update Order Item, Update Passenger, and Accept Reprice Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeOrderType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:AcceptRepricedOrderType" name="AcceptRepricedOrder" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:UpdateOrderItemType" name="UpdateOrderItem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:UpdatePaxType" name="UpdatePax" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ChangeOrderType implements Serializable
{
    private int choiceSelect = -1;
    private static final int ACCEPT_REPRICED_ORDER_CHOICE = 0;
    private static final int UPDATE_ORDER_ITEM_CHOICE = 1;
    private static final int UPDATE_PAX_LIST_CHOICE = 2;
    private AcceptRepricedOrderType acceptRepricedOrder;
    private UpdateOrderItemType updateOrderItem;
    private List<UpdatePaxType> updatePaxList = new ArrayList<UpdatePaxType>();

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AcceptRepricedOrder is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAcceptRepricedOrder() {
        return choiceSelect == ACCEPT_REPRICED_ORDER_CHOICE;
    }

    /** 
     * Get the 'AcceptRepricedOrder' element value. Function used by seller to inform the airline that it is accepting the proposed Order, as it has been repriced and returned in the preceding OrderReshopRS.
     * 
     * @return value
     */
    public AcceptRepricedOrderType getAcceptRepricedOrder() {
        return acceptRepricedOrder;
    }

    /** 
     * Set the 'AcceptRepricedOrder' element value. Function used by seller to inform the airline that it is accepting the proposed Order, as it has been repriced and returned in the preceding OrderReshopRS.
     * 
     * @param acceptRepricedOrder
     */
    public void setAcceptRepricedOrder(
            AcceptRepricedOrderType acceptRepricedOrder) {
        setChoiceSelect(ACCEPT_REPRICED_ORDER_CHOICE);
        this.acceptRepricedOrder = acceptRepricedOrder;
    }

    /** 
     * Check if UpdateOrderItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdateOrderItem() {
        return choiceSelect == UPDATE_ORDER_ITEM_CHOICE;
    }

    /** 
     * Get the 'UpdateOrderItem' element value. Collection of functions used by the seller to request the airline to commit changes to an existing Order. These may be adding, removing or replacing Order Items (with potential refund conditions, in case of cancellations). The actions possible are determined by the airline and communicated to the seller at the time of an OrderReshopRS (which precedes OrderChangeRQ). It is up to the seller to then accept the proposed actions from the OrderReshopRS by echoing these functions in this OrderServicing structure
     * 
     * @return value
     */
    public UpdateOrderItemType getUpdateOrderItem() {
        return updateOrderItem;
    }

    /** 
     * Set the 'UpdateOrderItem' element value. Collection of functions used by the seller to request the airline to commit changes to an existing Order. These may be adding, removing or replacing Order Items (with potential refund conditions, in case of cancellations). The actions possible are determined by the airline and communicated to the seller at the time of an OrderReshopRS (which precedes OrderChangeRQ). It is up to the seller to then accept the proposed actions from the OrderReshopRS by echoing these functions in this OrderServicing structure
     * 
     * @param updateOrderItem
     */
    public void setUpdateOrderItem(UpdateOrderItemType updateOrderItem) {
        setChoiceSelect(UPDATE_ORDER_ITEM_CHOICE);
        this.updateOrderItem = updateOrderItem;
    }

    /** 
     * Check if UpdatePaxList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifUpdatePaxList() {
        return choiceSelect == UPDATE_PAX_LIST_CHOICE;
    }

    /** 
     * Get the list of 'UpdatePax' element items. Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
     * 
     * @return list
     */
    public List<UpdatePaxType> getUpdatePaxList() {
        return updatePaxList;
    }

    /** 
     * Set the list of 'UpdatePax' element items. Function to Add, Remove or Update the Passenger Details. Providing the New and Previous values together implies an Update.
     * 
     * @param list
     */
    public void setUpdatePaxList(List<UpdatePaxType> list) {
        setChoiceSelect(UPDATE_PAX_LIST_CHOICE);
        updatePaxList = list;
    }
}
