
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Used for selling by value (long sells) rather than selling by reference.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CreateOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferItemID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OfferItemTimeLimitsType" name="OfferItemTimeLimits" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:OfferItemTypeType" name="OfferItemType" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CreateOrderItemType implements Serializable
{
    private String offerItemID;
    private List<OfferItemTimeLimitsType> offerItemTimeLimitList = new ArrayList<OfferItemTimeLimitsType>();
    private OfferItemTypeType offerItemType;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private String webAddressURI;

    /** 
     * Get the 'OfferItemID' element value. The airline-assigned unique Offer Item ID. Example: OFFER769-A850-4EC4-8F46-02293F72D7E6
     * 
     * @return value
     */
    public String getOfferItemID() {
        return offerItemID;
    }

    /** 
     * Set the 'OfferItemID' element value. The airline-assigned unique Offer Item ID. Example: OFFER769-A850-4EC4-8F46-02293F72D7E6
     * 
     * @param offerItemID
     */
    public void setOfferItemID(String offerItemID) {
        this.offerItemID = offerItemID;
    }

    /** 
     * Get the list of 'OfferItemTimeLimits' element items.
     * 
     * @return list
     */
    public List<OfferItemTimeLimitsType> getOfferItemTimeLimitList() {
        return offerItemTimeLimitList;
    }

    /** 
     * Set the list of 'OfferItemTimeLimits' element items.
     * 
     * @param list
     */
    public void setOfferItemTimeLimitList(List<OfferItemTimeLimitsType> list) {
        offerItemTimeLimitList = list;
    }

    /** 
     * Get the 'OfferItemType' element value. Offer Item Type used for long sell transactions.
     * 
     * @return value
     */
    public OfferItemTypeType getOfferItemType() {
        return offerItemType;
    }

    /** 
     * Set the 'OfferItemType' element value. Offer Item Type used for long sell transactions.
     * 
     * @param offerItemType
     */
    public void setOfferItemType(OfferItemTypeType offerItemType) {
        this.offerItemType = offerItemType;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA  Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline designator or CRS code of the owner/ assigner of the Offer ID, typically used for offer ordering purposes.  Example: UA, BA  Encoding Scheme: IATA/ A4A (two or three character) Airline or CRS Designator Code
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
