
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Currency Application Code enumeration information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurAppCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Actual"/>
 *     &lt;xs:enumeration value="Conversion"/>
 *     &lt;xs:enumeration value="Display"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Requested"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CurAppCodeContentType implements Serializable {
    ACTUAL("Actual"), CONVERSION("Conversion"), DISPLAY("Display"), OTHER(
            "Other"), REQUESTED("Requested");
    private final String value;

    private CurAppCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static CurAppCodeContentType convert(String value) {
        for (CurAppCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
