
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The result of converting one currency into another currency. E.g. local currency to USD, air miles to monetary.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurConversionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RateType" name="ConversionRate" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="LocalAmount" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CurConversionType implements Serializable
{
    private AmountType amount;
    private RateType conversionRate;
    private AmountType localAmount;

    /** 
     * Get the 'Amount' element value. Amount and currency specified in the converted currency. Example: 15000 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Amount and currency specified in the converted currency. Example: 15000 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ConversionRate' element value. Defines the rate used to convert the local currency into the billing currency.  Do we want to define an official name for the Billing Currency?
     * 
     * @return value
     */
    public RateType getConversionRate() {
        return conversionRate;
    }

    /** 
     * Set the 'ConversionRate' element value. Defines the rate used to convert the local currency into the billing currency.  Do we want to define an official name for the Billing Currency?
     * 
     * @param conversionRate
     */
    public void setConversionRate(RateType conversionRate) {
        this.conversionRate = conversionRate;
    }

    /** 
     * Get the 'LocalAmount' element value. Amount and currency as specified by the local Country.
     * 
     * @return value
     */
    public AmountType getLocalAmount() {
        return localAmount;
    }

    /** 
     * Set the 'LocalAmount' element value. Amount and currency as specified by the local Country.
     * 
     * @param localAmount
     */
    public void setLocalAmount(AmountType localAmount) {
        this.localAmount = localAmount;
    }
}
