
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * The commercial designation under which a Dated Operating Segment can be booked, either under the operating carrier's designator or that of another carrier (codeshare).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatedMarketingSegmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CarrierDesigCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CarrierName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MarketingCarrierFlightNumberText" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OperationalSuffixText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RBD_Code" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatedMarketingSegmentType implements Serializable
{
    private String carrierDesigCode;
    private String carrierName;
    private String marketingCarrierFlightNumberText;
    private String operationalSuffixText;
    private String RBDCode;

    /** 
     * Get the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getCarrierDesigCode() {
        return carrierDesigCode;
    }

    /** 
     * Set the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param carrierDesigCode
     */
    public void setCarrierDesigCode(String carrierDesigCode) {
        this.carrierDesigCode = carrierDesigCode;
    }

    /** 
     * Get the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @return value
     */
    public String getCarrierName() {
        return carrierName;
    }

    /** 
     * Set the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @param carrierName
     */
    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    /** 
     * Get the 'MarketingCarrierFlightNumberText' element value. The numerical designation of a flight as it is marketed by a carrier.
     * 
     * @return value
     */
    public String getMarketingCarrierFlightNumberText() {
        return marketingCarrierFlightNumberText;
    }

    /** 
     * Set the 'MarketingCarrierFlightNumberText' element value. The numerical designation of a flight as it is marketed by a carrier.
     * 
     * @param marketingCarrierFlightNumberText
     */
    public void setMarketingCarrierFlightNumberText(
            String marketingCarrierFlightNumberText) {
        this.marketingCarrierFlightNumberText = marketingCarrierFlightNumberText;
    }

    /** 
     * Get the 'OperationalSuffixText' element value.
     * 
     * @return value
     */
    public String getOperationalSuffixText() {
        return operationalSuffixText;
    }

    /** 
     * Set the 'OperationalSuffixText' element value.
     * 
     * @param operationalSuffixText
     */
    public void setOperationalSuffixText(String operationalSuffixText) {
        this.operationalSuffixText = operationalSuffixText;
    }

    /** 
     * Get the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @return value
     */
    public String getRBDCode() {
        return RBDCode;
    }

    /** 
     * Set the 'RBD_Code' element value. Code used to identify a particular RBD (e.g. P, J, W, M, etc.).
     * 
     * @param RBDCode
     */
    public void setRBDCode(String RBDCode) {
        this.RBDCode = RBDCode;
    }
}
