
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.Date;

/** 
 * The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DatedOperatingLegType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransportArrivalType" name="Arrival" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierAircraftTypeType" name="CarrierAircraftType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ChangeofGaugeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DatedOperatingLegID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TransportDepType" name="Dep" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="DistanceMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:IATA_AircraftTypeType" name="IATA_AircraftType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="OnGroundDuration" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DatedOperatingLegType implements Serializable
{
    private TransportArrivalType arrival;
    private CarrierAircraftTypeType carrierAircraftType;
    private Boolean changeofGaugeInd;
    private String datedOperatingLegID;
    private TransportDepType dep;
    private MeasureType distanceMeasure;
    private IATAAircraftTypeType IATAAircraftType;
    private Date onGroundDuration;

    /** 
     * Get the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @return value
     */
    public TransportArrivalType getArrival() {
        return arrival;
    }

    /** 
     * Set the 'Arrival' element value. The action or process of arriving of a transport vehicle in any place or location.
     * 
     * @param arrival
     */
    public void setArrival(TransportArrivalType arrival) {
        this.arrival = arrival;
    }

    /** 
     * Get the 'CarrierAircraftType' element value. Carrier defined internal grouping of aircrafts with the same form, function and specification.
     * 
     * @return value
     */
    public CarrierAircraftTypeType getCarrierAircraftType() {
        return carrierAircraftType;
    }

    /** 
     * Set the 'CarrierAircraftType' element value. Carrier defined internal grouping of aircrafts with the same form, function and specification.
     * 
     * @param carrierAircraftType
     */
    public void setCarrierAircraftType(
            CarrierAircraftTypeType carrierAircraftType) {
        this.carrierAircraftType = carrierAircraftType;
    }

    /** 
     * Get the 'ChangeofGaugeInd' element value. When TRUE, indicates a Change of Gauge will take place between the current leg and that which immediately precedes it.
     * 
     * @return value
     */
    public Boolean getChangeofGaugeInd() {
        return changeofGaugeInd;
    }

    /** 
     * Set the 'ChangeofGaugeInd' element value. When TRUE, indicates a Change of Gauge will take place between the current leg and that which immediately precedes it.
     * 
     * @param changeofGaugeInd
     */
    public void setChangeofGaugeInd(Boolean changeofGaugeInd) {
        this.changeofGaugeInd = changeofGaugeInd;
    }

    /** 
     * Get the 'DatedOperatingLegID' element value. Uniquely identifies a leg within the context of one message.
     * 
     * @return value
     */
    public String getDatedOperatingLegID() {
        return datedOperatingLegID;
    }

    /** 
     * Set the 'DatedOperatingLegID' element value. Uniquely identifies a leg within the context of one message.
     * 
     * @param datedOperatingLegID
     */
    public void setDatedOperatingLegID(String datedOperatingLegID) {
        this.datedOperatingLegID = datedOperatingLegID;
    }

    /** 
     * Get the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @return value
     */
    public TransportDepType getDep() {
        return dep;
    }

    /** 
     * Set the 'Dep' element value. The action or process of leaving of a transport vehicle from any place or location.
     * 
     * @param dep
     */
    public void setDep(TransportDepType dep) {
        this.dep = dep;
    }

    /** 
     * Get the 'DistanceMeasure' element value. Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * 
     * @return value
     */
    public MeasureType getDistanceMeasure() {
        return distanceMeasure;
    }

    /** 
     * Set the 'DistanceMeasure' element value. Total distance between the beginning and end stations of a leg, measured by the great circle of the earth.
     * 
     * @param distanceMeasure
     */
    public void setDistanceMeasure(MeasureType distanceMeasure) {
        this.distanceMeasure = distanceMeasure;
    }

    /** 
     * Get the 'IATA_AircraftType' element value. Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM.
     * 
     * @return value
     */
    public IATAAircraftTypeType getIATAAircraftType() {
        return IATAAircraftType;
    }

    /** 
     * Set the 'IATA_AircraftType' element value. Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM.
     * 
     * @param IATAAircraftType
     */
    public void setIATAAircraftType(IATAAircraftTypeType IATAAircraftType) {
        this.IATAAircraftType = IATAAircraftType;
    }

    /** 
     * Get the 'OnGroundDuration' element value. Total time the aircraft remains on the Ground between this leg and the leg which immediately precedes it.
     * 
     * @return value
     */
    public Date getOnGroundDuration() {
        return onGroundDuration;
    }

    /** 
     * Set the 'OnGroundDuration' element value. Total time the aircraft remains on the Ground between this leg and the leg which immediately precedes it.
     * 
     * @param onGroundDuration
     */
    public void setOnGroundDuration(Date onGroundDuration) {
        this.onGroundDuration = onGroundDuration;
    }
}
