
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Amount added on to a charge for a specific product, purpose, or service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FeeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="Amount" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ApproximateInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DesigText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="LocalAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="RefundInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FeeType implements Serializable
{
    private AmountType amount;
    private Boolean approximateInd;
    private String descText;
    private String desigText;
    private AmountType localAmount;
    private Boolean refundInd;

    /** 
     * Get the 'Amount' element value. Fee Amount. Example: 500 USD
     * 
     * @return value
     */
    public AmountType getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Fee Amount. Example: 500 USD
     * 
     * @param amount
     */
    public void setAmount(AmountType amount) {
        this.amount = amount;
    }

    /** 
     * Get the 'ApproximateInd' element value. When true, this fee is approximate.
     * 
     * @return value
     */
    public Boolean getApproximateInd() {
        return approximateInd;
    }

    /** 
     * Set the 'ApproximateInd' element value. When true, this fee is approximate.
     * 
     * @param approximateInd
     */
    public void setApproximateInd(Boolean approximateInd) {
        this.approximateInd = approximateInd;
    }

    /** 
     * Get the 'DescText' element value. Fee/ surcharge Description.  Example: U.S Customs User Fee
     * 
     * @return value
     */
    public String getDescText() {
        return descText;
    }

    /** 
     * Set the 'DescText' element value. Fee/ surcharge Description.  Example: U.S Customs User Fee
     * 
     * @param descText
     */
    public void setDescText(String descText) {
        this.descText = descText;
    }

    /** 
     * Get the 'DesigText' element value. Fee designator code. Example: USC
     * 
     * @return value
     */
    public String getDesigText() {
        return desigText;
    }

    /** 
     * Set the 'DesigText' element value. Fee designator code. Example: USC
     * 
     * @param desigText
     */
    public void setDesigText(String desigText) {
        this.desigText = desigText;
    }

    /** 
     * Get the 'LocalAmount' element value. Fee amount specified in a local currency. Example: 7 CHF
     * 
     * @return value
     */
    public AmountType getLocalAmount() {
        return localAmount;
    }

    /** 
     * Set the 'LocalAmount' element value. Fee amount specified in a local currency. Example: 7 CHF
     * 
     * @param localAmount
     */
    public void setLocalAmount(AmountType localAmount) {
        this.localAmount = localAmount;
    }

    /** 
     * Get the 'RefundInd' element value. When true, fee amount is refundable.
     * 
     * @return value
     */
    public Boolean getRefundInd() {
        return refundInd;
    }

    /** 
     * Set the 'RefundInd' element value. When true, fee amount is refundable.
     * 
     * @param refundInd
     */
    public void setRefundInd(Boolean refundInd) {
        this.refundInd = refundInd;
    }
}
