
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID. In the absence of a formal identity document, a driver's license may be accepted in many countries for identity verification. Most countries accept passports as a form of identification.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IdentityDocType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:date" name="Birthdate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BirthplaceText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CitizenshipCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="ExpiryDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:GenderCodeContentType" name="GenderCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="IdentityDocID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IdentityDocTypeCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="IssueDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="IssuingCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="xs:string" name="ResidenceCountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SuffixName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Surname" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TitleName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:VisaType" name="Visa" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentityDocType implements Serializable
{
    private Date birthdate;
    private String birthplaceText;
    private String citizenshipCountryCode;
    private Date expiryDate;
    private GenderCodeContentType genderCode;
    private List<String> givenNameList = new ArrayList<String>();
    private String identityDocID;
    private String identityDocTypeCode;
    private Date issueDate;
    private String issuingCountryCode;
    private List<String> middleNameList = new ArrayList<String>();
    private String residenceCountryCode;
    private String suffixName;
    private String surname;
    private String titleName;
    private List<VisaType> visaList = new ArrayList<VisaType>();

    /** 
     * Get the 'Birthdate' element value. Holderâ€™s date of birth as written on the document.
     * 
     * @return value
     */
    public Date getBirthdate() {
        return birthdate;
    }

    /** 
     * Set the 'Birthdate' element value. Holderâ€™s date of birth as written on the document.
     * 
     * @param birthdate
     */
    public void setBirthdate(Date birthdate) {
        this.birthdate = birthdate;
    }

    /** 
     * Get the 'BirthplaceText' element value. Holder's birth location (e.g. city and/or country) as written on the  document.
     * 
     * @return value
     */
    public String getBirthplaceText() {
        return birthplaceText;
    }

    /** 
     * Set the 'BirthplaceText' element value. Holder's birth location (e.g. city and/or country) as written on the  document.
     * 
     * @param birthplaceText
     */
    public void setBirthplaceText(String birthplaceText) {
        this.birthplaceText = birthplaceText;
    }

    /** 
     * Get the 'CitizenshipCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getCitizenshipCountryCode() {
        return citizenshipCountryCode;
    }

    /** 
     * Set the 'CitizenshipCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param citizenshipCountryCode
     */
    public void setCitizenshipCountryCode(String citizenshipCountryCode) {
        this.citizenshipCountryCode = citizenshipCountryCode;
    }

    /** 
     * Get the 'ExpiryDate' element value. The date the identity document expires.
     * 
     * @return value
     */
    public Date getExpiryDate() {
        return expiryDate;
    }

    /** 
     * Set the 'ExpiryDate' element value. The date the identity document expires.
     * 
     * @param expiryDate
     */
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }

    /** 
     * Get the 'GenderCode' element value. Holderâ€™s gender as specified on the document (M, F, or X for unspecified).
     * 
     * @return value
     */
    public GenderCodeContentType getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' element value. Holderâ€™s gender as specified on the document (M, F, or X for unspecified).
     * 
     * @param genderCode
     */
    public void setGenderCode(GenderCodeContentType genderCode) {
        this.genderCode = genderCode;
    }

    /** 
     * Get the list of 'GivenName' element items. Holder's first or given name, as written on the document. E.g. JOHN.
     * 
     * @return list
     */
    public List<String> getGivenNameList() {
        return givenNameList;
    }

    /** 
     * Set the list of 'GivenName' element items. Holder's first or given name, as written on the document. E.g. JOHN.
     * 
     * @param list
     */
    public void setGivenNameList(List<String> list) {
        givenNameList = list;
    }

    /** 
     * Get the 'IdentityDocID' element value. Uniquely identifies the document from all other identity documents issued by the state or organization. e.g. passport number, drivers license number.
     * 
     * @return value
     */
    public String getIdentityDocID() {
        return identityDocID;
    }

    /** 
     * Set the 'IdentityDocID' element value. Uniquely identifies the document from all other identity documents issued by the state or organization. e.g. passport number, drivers license number.
     * 
     * @param identityDocID
     */
    public void setIdentityDocID(String identityDocID) {
        this.identityDocID = identityDocID;
    }

    /** 
     * Get the 'IdentityDocTypeCode' element value. The type of passenger document.  Examples: PT (Passport)
     * 
     * @return value
     */
    public String getIdentityDocTypeCode() {
        return identityDocTypeCode;
    }

    /** 
     * Set the 'IdentityDocTypeCode' element value. The type of passenger document.  Examples: PT (Passport)
     * 
     * @param identityDocTypeCode
     */
    public void setIdentityDocTypeCode(String identityDocTypeCode) {
        this.identityDocTypeCode = identityDocTypeCode;
    }

    /** 
     * Get the 'IssueDate' element value. The date the identity document was issued.
     * 
     * @return value
     */
    public Date getIssueDate() {
        return issueDate;
    }

    /** 
     * Set the 'IssueDate' element value. The date the identity document was issued.
     * 
     * @param issueDate
     */
    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /** 
     * Get the 'IssuingCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getIssuingCountryCode() {
        return issuingCountryCode;
    }

    /** 
     * Set the 'IssuingCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param issuingCountryCode
     */
    public void setIssuingCountryCode(String issuingCountryCode) {
        this.issuingCountryCode = issuingCountryCode;
    }

    /** 
     * Get the list of 'MiddleName' element items. Holder's middle name or initial, as written on the document. E.g. G, GEORGE.
     * 
     * @return list
     */
    public List<String> getMiddleNameList() {
        return middleNameList;
    }

    /** 
     * Set the list of 'MiddleName' element items. Holder's middle name or initial, as written on the document. E.g. G, GEORGE.
     * 
     * @param list
     */
    public void setMiddleNameList(List<String> list) {
        middleNameList = list;
    }

    /** 
     * Get the 'ResidenceCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getResidenceCountryCode() {
        return residenceCountryCode;
    }

    /** 
     * Set the 'ResidenceCountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param residenceCountryCode
     */
    public void setResidenceCountryCode(String residenceCountryCode) {
        this.residenceCountryCode = residenceCountryCode;
    }

    /** 
     * Get the 'SuffixName' element value. Holder's name suffixes and letters, as written on the document. E.g. Jr., Sr., III, Ret., Esq.
     * 
     * @return value
     */
    public String getSuffixName() {
        return suffixName;
    }

    /** 
     * Set the 'SuffixName' element value. Holder's name suffixes and letters, as written on the document. E.g. Jr., Sr., III, Ret., Esq.
     * 
     * @param suffixName
     */
    public void setSuffixName(String suffixName) {
        this.suffixName = suffixName;
    }

    /** 
     * Get the 'Surname' element value. Holder's family name or last name, as written on the document. E.g. SMITH. Excludes any potential suffix.
     * 
     * @return value
     */
    public String getSurname() {
        return surname;
    }

    /** 
     * Set the 'Surname' element value. Holder's family name or last name, as written on the document. E.g. SMITH. Excludes any potential suffix.
     * 
     * @param surname
     */
    public void setSurname(String surname) {
        this.surname = surname;
    }

    /** 
     * Get the 'TitleName' element value. Holder's title as written on the document. E.g. Mr., Mrs., Miss, Dr.
     * 
     * @return value
     */
    public String getTitleName() {
        return titleName;
    }

    /** 
     * Set the 'TitleName' element value. Holder's title as written on the document. E.g. Mr., Mrs., Miss, Dr.
     * 
     * @param titleName
     */
    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    /** 
     * Get the list of 'Visa' element items. An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
     * 
     * @return list
     */
    public List<VisaType> getVisaList() {
        return visaList;
    }

    /** 
     * Set the list of 'Visa' element items. An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
     * 
     * @param list
     */
    public void setVisaList(List<VisaType> list) {
        visaList = list;
    }
}
