
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * List of Length Unit Codes. Subset of UN/CEFACT Recommendation 20. {codeListAgencyName}AIDM (extract from UN/CEFACT){/codeListAgencyName}
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LengthUnitCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CMT"/>
 *     &lt;xs:enumeration value="FOT"/>
 *     &lt;xs:enumeration value="INH"/>
 *     &lt;xs:enumeration value="MTR"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum LengthUnitCodeContentType implements Serializable {
    /** 
     * Centimeter
     */
    CMT, /** 
          * Foot
          */
    FOT, /** 
          * Inch
          */
    INH, /** 
          * Meter
          */
    MTR
}
