
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * An account set up for a customer within a rewards program which holds funds on behalf of that customer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LoyaltyProgramAccountType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AccountNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AllianceType" name="Alliance" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:LoyaltyProgramType" name="LoyaltyProgram" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProgramCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProgramName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ProviderName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SignInID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TierPriorityText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyProgramAccountType implements Serializable
{
    private String accountNumber;
    private AllianceType alliance;
    private CarrierType carrier;
    private LoyaltyProgramType loyaltyProgram;
    private String programCode;
    private String programName;
    private String providerName;
    private String signInID;
    private String tierCode;
    private String tierName;
    private String tierPriorityText;
    private String URL;

    /** 
     * Get the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @return value
     */
    public String getAccountNumber() {
        return accountNumber;
    }

    /** 
     * Set the 'AccountNumber' element value. Loyalty Program account number. Example: ABC123456
     * 
     * @param accountNumber
     */
    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    /** 
     * Get the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @return value
     */
    public AllianceType getAlliance() {
        return alliance;
    }

    /** 
     * Set the 'Alliance' element value. Two or more airlines participating in a commercial relationship or joint venture, where a joint and commonly identifiable product is marketed under a single commercial name or brand.
     * 
     * @param alliance
     */
    public void setAlliance(AllianceType alliance) {
        this.alliance = alliance;
    }

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'LoyaltyProgram' element value. A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
     * 
     * @return value
     */
    public LoyaltyProgramType getLoyaltyProgram() {
        return loyaltyProgram;
    }

    /** 
     * Set the 'LoyaltyProgram' element value. A rewards program offered by a company to customers who frequently make purchases, which may give a customer advanced access to new products, special sales coupons or free merchandise.
     * 
     * @param loyaltyProgram
     */
    public void setLoyaltyProgram(LoyaltyProgramType loyaltyProgram) {
        this.loyaltyProgram = loyaltyProgram;
    }

    /** 
     * Get the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @return value
     */
    public String getProgramCode() {
        return programCode;
    }

    /** 
     * Set the 'ProgramCode' element value. Loyalty Program ID: Example: MAM
     * 
     * @param programCode
     */
    public void setProgramCode(String programCode) {
        this.programCode = programCode;
    }

    /** 
     * Get the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @return value
     */
    public String getProgramName() {
        return programName;
    }

    /** 
     * Set the 'ProgramName' element value. Loyalty Program Name. Example: Miles and More
     * 
     * @param programName
     */
    public void setProgramName(String programName) {
        this.programName = programName;
    }

    /** 
     * Get the 'ProviderName' element value. Name of the organization providing the Loyalty Program.
     * 
     * @return value
     */
    public String getProviderName() {
        return providerName;
    }

    /** 
     * Set the 'ProviderName' element value. Name of the organization providing the Loyalty Program.
     * 
     * @param providerName
     */
    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    /** 
     * Get the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @return value
     */
    public String getSignInID() {
        return signInID;
    }

    /** 
     * Set the 'SignInID' element value. Loyalty Program sign-in ID (or username).
     * 
     * @param signInID
     */
    public void setSignInID(String signInID) {
        this.signInID = signInID;
    }

    /** 
     * Get the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @return value
     */
    public String getTierCode() {
        return tierCode;
    }

    /** 
     * Set the 'TierCode' element value. Loyalty Program tier code.
     * 
     * @param tierCode
     */
    public void setTierCode(String tierCode) {
        this.tierCode = tierCode;
    }

    /** 
     * Get the 'TierName' element value. Loyalty Program tier name.
     * 
     * @return value
     */
    public String getTierName() {
        return tierName;
    }

    /** 
     * Set the 'TierName' element value. Loyalty Program tier name.
     * 
     * @param tierName
     */
    public void setTierName(String tierName) {
        this.tierName = tierName;
    }

    /** 
     * Get the 'TierPriorityText' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @return value
     */
    public String getTierPriorityText() {
        return tierPriorityText;
    }

    /** 
     * Set the 'TierPriorityText' element value. Loyalty Program account priority within the tier (e.g. Platinum, executive, etc.)
     * 
     * @param tierPriorityText
     */
    public void setTierPriorityText(String tierPriorityText) {
        this.tierPriorityText = tierPriorityText;
    }

    /** 
     * Get the 'URL' element value. Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Loyalty Program information URL. Example: https://www.britishairways.com/en-gb/executive-club/about-the-club
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }
}
