
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Offer Item Type used for long sell transactions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItemTypeType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:BaggageItemType" name="BaggageItem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FlightItemType" name="FlightItem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OtherItemType" name="OtherItem" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatItemType" name="SeatItem" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OfferItemTypeType implements Serializable
{
    private int choiceSelect = -1;
    private static final int BAGGAGE_ITEM_CHOICE = 0;
    private static final int FLIGHT_ITEM_CHOICE = 1;
    private static final int OTHER_ITEM_CHOICE = 2;
    private static final int SEAT_ITEM_CHOICE = 3;
    private BaggageItemType baggageItem;
    private FlightItemType flightItem;
    private OtherItemType otherItem;
    private SeatItemType seatItem;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if BaggageItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifBaggageItem() {
        return choiceSelect == BAGGAGE_ITEM_CHOICE;
    }

    /** 
     * Get the 'BaggageItem' element value. Baggage service information used for long sells.
     * 
     * @return value
     */
    public BaggageItemType getBaggageItem() {
        return baggageItem;
    }

    /** 
     * Set the 'BaggageItem' element value. Baggage service information used for long sells.
     * 
     * @param baggageItem
     */
    public void setBaggageItem(BaggageItemType baggageItem) {
        setChoiceSelect(BAGGAGE_ITEM_CHOICE);
        this.baggageItem = baggageItem;
    }

    /** 
     * Check if FlightItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFlightItem() {
        return choiceSelect == FLIGHT_ITEM_CHOICE;
    }

    /** 
     * Get the 'FlightItem' element value. Flight service information used for long sells.
     * 
     * @return value
     */
    public FlightItemType getFlightItem() {
        return flightItem;
    }

    /** 
     * Set the 'FlightItem' element value. Flight service information used for long sells.
     * 
     * @param flightItem
     */
    public void setFlightItem(FlightItemType flightItem) {
        setChoiceSelect(FLIGHT_ITEM_CHOICE);
        this.flightItem = flightItem;
    }

    /** 
     * Check if OtherItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifOtherItem() {
        return choiceSelect == OTHER_ITEM_CHOICE;
    }

    /** 
     * Get the 'OtherItem' element value. Other service information used for long sells.
     * 
     * @return value
     */
    public OtherItemType getOtherItem() {
        return otherItem;
    }

    /** 
     * Set the 'OtherItem' element value. Other service information used for long sells.
     * 
     * @param otherItem
     */
    public void setOtherItem(OtherItemType otherItem) {
        setChoiceSelect(OTHER_ITEM_CHOICE);
        this.otherItem = otherItem;
    }

    /** 
     * Check if SeatItem is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatItem() {
        return choiceSelect == SEAT_ITEM_CHOICE;
    }

    /** 
     * Get the 'SeatItem' element value. Seat service information used for long sells.
     * 
     * @return value
     */
    public SeatItemType getSeatItem() {
        return seatItem;
    }

    /** 
     * Set the 'SeatItem' element value. Seat service information used for long sells.
     * 
     * @param seatItem
     */
    public void setSeatItem(SeatItemType seatItem) {
        setChoiceSelect(SEAT_ITEM_CHOICE);
        this.seatItem = seatItem;
    }
}
