
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DateTimeType" name="CreationDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="DepositTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="LastModifiedDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DateTimeType" name="NamingTimeLimitDateTime" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OwnerTypeCodeContentType" name="OwnerTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderStatusCodeContentType" name="StatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="WebAddressURI" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderType implements Serializable
{
    private DateTimeType creationDateTime;
    private DateTimeType depositTimeLimitDateTime;
    private DateTimeType lastModifiedDateTime;
    private DateTimeType namingTimeLimitDateTime;
    private String orderID;
    private String ownerCode;
    private OwnerTypeCodeContentType ownerTypeCode;
    private OrderStatusCodeContentType statusCode;
    private String webAddressURI;

    /** 
     * Get the 'CreationDateTime' element value. The date time by which the order is created. Examples: 2018-09-05T15:52:01Z
     * 
     * @return value
     */
    public DateTimeType getCreationDateTime() {
        return creationDateTime;
    }

    /** 
     * Set the 'CreationDateTime' element value. The date time by which the order is created. Examples: 2018-09-05T15:52:01Z
     * 
     * @param creationDateTime
     */
    public void setCreationDateTime(DateTimeType creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    /** 
     * Get the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getDepositTimeLimitDateTime() {
        return depositTimeLimitDateTime;
    }

    /** 
     * Set the 'DepositTimeLimitDateTime' element value. The date by which a deposit must be paid for an order Examples:  2015-01-13T13:59:38Z
     * 
     * @param depositTimeLimitDateTime
     */
    public void setDepositTimeLimitDateTime(
            DateTimeType depositTimeLimitDateTime) {
        this.depositTimeLimitDateTime = depositTimeLimitDateTime;
    }

    /** 
     * Get the 'LastModifiedDateTime' element value. The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z
     * 
     * @return value
     */
    public DateTimeType getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }

    /** 
     * Set the 'LastModifiedDateTime' element value. The date time by which the order is modified. Examples: 2018-09-05T15:52:01Z
     * 
     * @param lastModifiedDateTime
     */
    public void setLastModifiedDateTime(DateTimeType lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }

    /** 
     * Get the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @return value
     */
    public DateTimeType getNamingTimeLimitDateTime() {
        return namingTimeLimitDateTime;
    }

    /** 
     * Set the 'NamingTimeLimitDateTime' element value. The time by which an Order must be completed with individual passenger names. Examples: 2015-01-13T13:59:38Z
     * 
     * @param namingTimeLimitDateTime
     */
    public void setNamingTimeLimitDateTime(DateTimeType namingTimeLimitDateTime) {
        this.namingTimeLimitDateTime = namingTimeLimitDateTime;
    }

    /** 
     * Get the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @return value
     */
    public String getOrderID() {
        return orderID;
    }

    /** 
     * Set the 'OrderID' element value. Carrier assigned ID which uniquely identifies a specific Order across several messages.
     * 
     * @param orderID
     */
    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @return value
     */
    public OwnerTypeCodeContentType getOwnerTypeCode() {
        return ownerTypeCode;
    }

    /** 
     * Set the 'OwnerTypeCode' element value. Indicates whether the owner is the ORA or POA.
     * 
     * @param ownerTypeCode
     */
    public void setOwnerTypeCode(OwnerTypeCodeContentType ownerTypeCode) {
        this.ownerTypeCode = ownerTypeCode;
    }

    /** 
     * Get the 'StatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @return value
     */
    public OrderStatusCodeContentType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value. Indicates the current status of an Order E.g. OK (Confirmed)
     * 
     * @param statusCode
     */
    public void setStatusCode(OrderStatusCodeContentType statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @return value
     */
    public String getWebAddressURI() {
        return webAddressURI;
    }

    /** 
     * Set the 'WebAddressURI' element value. Deep linking into another site to complete the transaction. E.g. to bring the customer directly to a page to continue with a purchase of a specific offer.
     * 
     * @param webAddressURI
     */
    public void setWebAddressURI(String webAddressURI) {
        this.webAddressURI = webAddressURI;
    }
}
