
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Transportation of a passenger on a Dated Operating Leg.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaxLegType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DatedOperatingLegType" name="DatedOperatingLeg" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxLegID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaxLegType implements Serializable
{
    private DatedOperatingLegType datedOperatingLeg;
    private String paxLegID;

    /** 
     * Get the 'DatedOperatingLeg' element value. The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
     * 
     * @return value
     */
    public DatedOperatingLegType getDatedOperatingLeg() {
        return datedOperatingLeg;
    }

    /** 
     * Set the 'DatedOperatingLeg' element value. The nonstop operation of a transport vehicle between the departure station and the arrival station. Can be used for aircrafts as well as other transport vehicles such as train or bus etc.
     * 
     * @param datedOperatingLeg
     */
    public void setDatedOperatingLeg(DatedOperatingLegType datedOperatingLeg) {
        this.datedOperatingLeg = datedOperatingLeg;
    }

    /** 
     * Get the 'PaxLegID' element value. Uniquely identifies a Passenger Leg within the context of one message.
     * 
     * @return value
     */
    public String getPaxLegID() {
        return paxLegID;
    }

    /** 
     * Set the 'PaxLegID' element value. Uniquely identifies a Passenger Leg within the context of one message.
     * 
     * @param paxLegID
     */
    public void setPaxLegID(String paxLegID) {
        this.paxLegID = paxLegID;
    }
}
