
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * A device that enables its owner (the cardholder) to make a payment by electronic funds transfer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentCardType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CardBrandCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardHolderName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CardNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardProductTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardSecurityCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="CardSeqNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CardTypeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:EncryptedDataType" name="EncryptedData" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ExpirationDate" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="First6DigitsText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Last4DigitsText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ProtectedCardID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReconciliationID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SecurePayerAuthenticationType" name="SecurePayerAuthentication" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SecurePayerAuthenticationInstructionsType" name="SecurePayerAuthenticationInstructions" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SecureProgramType" name="SecureProgram" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="SellerOwnCardInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentCardType implements Serializable
{
    private String cardBrandCode;
    private String cardHolderName;
    private String cardNumber;
    private String cardProductTypeCode;
    private String cardSecurityCode;
    private BigDecimal cardSeqNumber;
    private String cardTypeText;
    private EncryptedDataType encryptedData;
    private String expirationDate;
    private String first6DigitsText;
    private String last4DigitsText;
    private String protectedCardID;
    private String reconciliationID;
    private SecurePayerAuthenticationType securePayerAuthentication;
    private SecurePayerAuthenticationInstructionsType securePayerAuthenticationInstructions;
    private SecureProgramType secureProgram;
    private Boolean sellerOwnCardInd;

    /** 
     * Get the 'CardBrandCode' element value. A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa
     * 
     * @return value
     */
    public String getCardBrandCode() {
        return cardBrandCode;
    }

    /** 
     * Set the 'CardBrandCode' element value. A two-letter code assigned according to IATA Resolution 728. Example: VI for Visa
     * 
     * @param cardBrandCode
     */
    public void setCardBrandCode(String cardBrandCode) {
        this.cardBrandCode = cardBrandCode;
    }

    /** 
     * Get the 'CardHolderName' element value. Name of credit card holder. Example: JOHN SMITH
     * 
     * @return value
     */
    public String getCardHolderName() {
        return cardHolderName;
    }

    /** 
     * Set the 'CardHolderName' element value. Name of credit card holder. Example: JOHN SMITH
     * 
     * @param cardHolderName
     */
    public void setCardHolderName(String cardHolderName) {
        this.cardHolderName = cardHolderName;
    }

    /** 
     * Get the 'CardNumber' element value. The card number indicated on the payment card.
     * 
     * @return value
     */
    public String getCardNumber() {
        return cardNumber;
    }

    /** 
     * Set the 'CardNumber' element value. The card number indicated on the payment card.
     * 
     * @param cardNumber
     */
    public void setCardNumber(String cardNumber) {
        this.cardNumber = cardNumber;
    }

    /** 
     * Get the 'CardProductTypeCode' element value. Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card.
     * 
     * @return value
     */
    public String getCardProductTypeCode() {
        return cardProductTypeCode;
    }

    /** 
     * Set the 'CardProductTypeCode' element value. Used to specify whether the card is a Consumer (personal) or Commercial (corporate) card.
     * 
     * @param cardProductTypeCode
     */
    public void setCardProductTypeCode(String cardProductTypeCode) {
        this.cardProductTypeCode = cardProductTypeCode;
    }

    /** 
     * Get the 'CardSecurityCode' element value. 3-digit number printed on the signature panel on the back of the card and following the last four digits of the Primary Account Number (PAN). For American Express,  4 digits located on the front of the card, above the card number on the right hand side. Visa - CVV2, MasterCard - CVC2, American Express - CID, Discover - CMID, Union Pay - CVN2, JCB - CAV2.
     * 
     * @return value
     */
    public String getCardSecurityCode() {
        return cardSecurityCode;
    }

    /** 
     * Set the 'CardSecurityCode' element value. 3-digit number printed on the signature panel on the back of the card and following the last four digits of the Primary Account Number (PAN). For American Express,  4 digits located on the front of the card, above the card number on the right hand side. Visa - CVV2, MasterCard - CVC2, American Express - CID, Discover - CMID, Union Pay - CVN2, JCB - CAV2.
     * 
     * @param cardSecurityCode
     */
    public void setCardSecurityCode(String cardSecurityCode) {
        this.cardSecurityCode = cardSecurityCode;
    }

    /** 
     * Get the 'CardSeqNumber' element value. Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number.
     * 
     * @return value
     */
    public BigDecimal getCardSeqNumber() {
        return cardSeqNumber;
    }

    /** 
     * Set the 'CardSeqNumber' element value. Number displayed on a payment card following the card number which indicates if the card is an original or if it was re-issued with the same card number.
     * 
     * @param cardSeqNumber
     */
    public void setCardSeqNumber(BigDecimal cardSeqNumber) {
        this.cardSeqNumber = cardSeqNumber;
    }

    /** 
     * Get the 'CardTypeText' element value. Additional description for the magnetic stripe card type (debit card, credit card, prepaid card, etc.)
     * 
     * @return value
     */
    public String getCardTypeText() {
        return cardTypeText;
    }

    /** 
     * Set the 'CardTypeText' element value. Additional description for the magnetic stripe card type (debit card, credit card, prepaid card, etc.)
     * 
     * @param cardTypeText
     */
    public void setCardTypeText(String cardTypeText) {
        this.cardTypeText = cardTypeText;
    }

    /** 
     * Get the 'EncryptedData' element value.
     * 
     * @return value
     */
    public EncryptedDataType getEncryptedData() {
        return encryptedData;
    }

    /** 
     * Set the 'EncryptedData' element value.
     * 
     * @param encryptedData
     */
    public void setEncryptedData(EncryptedDataType encryptedData) {
        this.encryptedData = encryptedData;
    }

    /** 
     * Get the 'ExpirationDate' element value. The last month of validity Example: 0119
     * 
     * @return value
     */
    public String getExpirationDate() {
        return expirationDate;
    }

    /** 
     * Set the 'ExpirationDate' element value. The last month of validity Example: 0119
     * 
     * @param expirationDate
     */
    public void setExpirationDate(String expirationDate) {
        this.expirationDate = expirationDate;
    }

    /** 
     * Get the 'First6DigitsText' element value.
     * 
     * @return value
     */
    public String getFirst6DigitsText() {
        return first6DigitsText;
    }

    /** 
     * Set the 'First6DigitsText' element value.
     * 
     * @param first6DigitsText
     */
    public void setFirst6DigitsText(String first6DigitsText) {
        this.first6DigitsText = first6DigitsText;
    }

    /** 
     * Get the 'Last4DigitsText' element value.
     * 
     * @return value
     */
    public String getLast4DigitsText() {
        return last4DigitsText;
    }

    /** 
     * Set the 'Last4DigitsText' element value.
     * 
     * @param last4DigitsText
     */
    public void setLast4DigitsText(String last4DigitsText) {
        this.last4DigitsText = last4DigitsText;
    }

    /** 
     * Get the 'ProtectedCardID' element value. Payment card number protected in a non format preserving fashion.
     * 
     * @return value
     */
    public String getProtectedCardID() {
        return protectedCardID;
    }

    /** 
     * Set the 'ProtectedCardID' element value. Payment card number protected in a non format preserving fashion.
     * 
     * @param protectedCardID
     */
    public void setProtectedCardID(String protectedCardID) {
        this.protectedCardID = protectedCardID;
    }

    /** 
     * Get the 'ReconciliationID' element value. Identifies the individual for this specific transaction when the card is shared (for example, corporate card).  This ID is typically used for payment reconciliation.
     * 
     * @return value
     */
    public String getReconciliationID() {
        return reconciliationID;
    }

    /** 
     * Set the 'ReconciliationID' element value. Identifies the individual for this specific transaction when the card is shared (for example, corporate card).  This ID is typically used for payment reconciliation.
     * 
     * @param reconciliationID
     */
    public void setReconciliationID(String reconciliationID) {
        this.reconciliationID = reconciliationID;
    }

    /** 
     * Get the 'SecurePayerAuthentication' element value. Contains the indicators and fields that convey the result of the 3D Secure authentication transaction.  Applicable for 3D Secure Version V 1.0.
     * 
     * @return value
     */
    public SecurePayerAuthenticationType getSecurePayerAuthentication() {
        return securePayerAuthentication;
    }

    /** 
     * Set the 'SecurePayerAuthentication' element value. Contains the indicators and fields that convey the result of the 3D Secure authentication transaction.  Applicable for 3D Secure Version V 1.0.
     * 
     * @param securePayerAuthentication
     */
    public void setSecurePayerAuthentication(
            SecurePayerAuthenticationType securePayerAuthentication) {
        this.securePayerAuthentication = securePayerAuthentication;
    }

    /** 
     * Get the 'SecurePayerAuthenticationInstructions' element value. Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable to cardholder to authenticate.  Applicable for 3D Secure Version V 1.0.
     * 
     * @return value
     */
    public SecurePayerAuthenticationInstructionsType getSecurePayerAuthenticationInstructions() {
        return securePayerAuthenticationInstructions;
    }

    /** 
     * Set the 'SecurePayerAuthenticationInstructions' element value. Data returned from the Directory Server/ACS containing the PAReq and the ACS URL that enable to cardholder to authenticate.  Applicable for 3D Secure Version V 1.0.
     * 
     * @param securePayerAuthenticationInstructions
     */
    public void setSecurePayerAuthenticationInstructions(
            SecurePayerAuthenticationInstructionsType securePayerAuthenticationInstructions) {
        this.securePayerAuthenticationInstructions = securePayerAuthenticationInstructions;
    }

    /** 
     * Get the 'SecureProgram' element value. Contains enrolment information of the Payment Card.  e.g. Verified by Visa.
     * 
     * @return value
     */
    public SecureProgramType getSecureProgram() {
        return secureProgram;
    }

    /** 
     * Set the 'SecureProgram' element value. Contains enrolment information of the Payment Card.  e.g. Verified by Visa.
     * 
     * @param secureProgram
     */
    public void setSecureProgram(SecureProgramType secureProgram) {
        this.secureProgram = secureProgram;
    }

    /** 
     * Get the 'SellerOwnCardInd' element value. When TRUE, indicates the seller is using their own card.  If FALSE, customer card is being used.
     * 
     * @return value
     */
    public Boolean getSellerOwnCardInd() {
        return sellerOwnCardInd;
    }

    /** 
     * Set the 'SellerOwnCardInd' element value. When TRUE, indicates the seller is using their own card.  If FALSE, customer card is being used.
     * 
     * @param sellerOwnCardInd
     */
    public void setSellerOwnCardInd(Boolean sellerOwnCardInd) {
        this.sellerOwnCardInd = sellerOwnCardInd;
    }
}
