
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Additional identification and URLs used to further describe a secure payment transaction.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentTrxRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="InputCurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OriginalID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentAddressVerificationType" name="PaymentAddressVerification" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SettlementCurCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TrxDataText" minOccurs="0" maxOccurs="3"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PaymentTrxRefType implements Serializable
{
    private String inputCurCode;
    private String originalID;
    private PaymentAddressVerificationType paymentAddressVerification;
    private String settlementCurCode;
    private List<String> trxDataTextList = new ArrayList<String>();

    /** 
     * Get the 'InputCurCode' element value. Input Payment Currency code. Example: USD
     * 
     * @return value
     */
    public String getInputCurCode() {
        return inputCurCode;
    }

    /** 
     * Set the 'InputCurCode' element value. Input Payment Currency code. Example: USD
     * 
     * @param inputCurCode
     */
    public void setInputCurCode(String inputCurCode) {
        this.inputCurCode = inputCurCode;
    }

    /** 
     * Get the 'OriginalID' element value.
     * 
     * @return value
     */
    public String getOriginalID() {
        return originalID;
    }

    /** 
     * Set the 'OriginalID' element value.
     * 
     * @param originalID
     */
    public void setOriginalID(String originalID) {
        this.originalID = originalID;
    }

    /** 
     * Get the 'PaymentAddressVerification' element value. Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * 
     * @return value
     */
    public PaymentAddressVerificationType getPaymentAddressVerification() {
        return paymentAddressVerification;
    }

    /** 
     * Set the 'PaymentAddressVerification' element value. Secure Payment-related Processing information, including AVS/ CVV Verification Results and Secure Payment Processing Results.
     * 
     * @param paymentAddressVerification
     */
    public void setPaymentAddressVerification(
            PaymentAddressVerificationType paymentAddressVerification) {
        this.paymentAddressVerification = paymentAddressVerification;
    }

    /** 
     * Get the 'SettlementCurCode' element value. Settlement Payment Currency code. Example: CHF
     * 
     * @return value
     */
    public String getSettlementCurCode() {
        return settlementCurCode;
    }

    /** 
     * Set the 'SettlementCurCode' element value. Settlement Payment Currency code. Example: CHF
     * 
     * @param settlementCurCode
     */
    public void setSettlementCurCode(String settlementCurCode) {
        this.settlementCurCode = settlementCurCode;
    }

    /** 
     * Get the list of 'TrxDataText' element items. Other (free form text) transaction data.
     * 
     * @return list
     */
    public List<String> getTrxDataTextList() {
        return trxDataTextList;
    }

    /** 
     * Set the list of 'TrxDataText' element items. Other (free form text) transaction data.
     * 
     * @param list
     */
    public void setTrxDataTextList(List<String> list) {
        trxDataTextList = list;
    }
}
