
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Enumeration set values for Penalty Type. {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyTypeCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Cancellation"/>
 *     &lt;xs:enumeration value="Change"/>
 *     &lt;xs:enumeration value="NoShow"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Upgrade"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PenaltyTypeCodeContentType implements Serializable {
    /** 
     * Cancellation
     */
    CANCELLATION("Cancellation"), /** 
                                   * Change
                                   */
    CHANGE("Change"), /** 
                       * NoShow
                       */
    NO_SHOW("NoShow"), /** 
                        * Other
                        */
    OTHER("Other"), /** 
                     * Upgrade
                     */
    UPGRADE("Upgrade");
    private final String value;

    private PenaltyTypeCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PenaltyTypeCodeContentType convert(String value) {
        for (PenaltyTypeCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
