
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Message policy information, including PCI, PII information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PolicyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DescType" name="Desc" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PolicyNodeInfoType" name="PolicyNodeInfo" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PolicyTypeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="VersionNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PolicyType implements Serializable
{
    private List<DescType> descList = new ArrayList<DescType>();
    private String ownerName;
    private List<PolicyNodeInfoType> policyNodeInfoList = new ArrayList<PolicyNodeInfoType>();
    private String policyTypeText;
    private BigDecimal versionNumber;

    /** 
     * Get the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getDescList() {
        return descList;
    }

    /** 
     * Set the list of 'Desc' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setDescList(List<DescType> list) {
        descList = list;
    }

    /** 
     * Get the 'OwnerName' element value. Source Entity Name or Code (e.g. BA, WIDGETCO).
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. Source Entity Name or Code (e.g. BA, WIDGETCO).
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the list of 'PolicyNodeInfo' element items. Policy data node detail, including an XPATH and associated Tag Name.
     * 
     * @return list
     */
    public List<PolicyNodeInfoType> getPolicyNodeInfoList() {
        return policyNodeInfoList;
    }

    /** 
     * Set the list of 'PolicyNodeInfo' element items. Policy data node detail, including an XPATH and associated Tag Name.
     * 
     * @param list
     */
    public void setPolicyNodeInfoList(List<PolicyNodeInfoType> list) {
        policyNodeInfoList = list;
    }

    /** 
     * Get the 'PolicyTypeText' element value. Policy Type, examples: Policy Type. Examples: Privacy_PII, Payment_PCI, Credentialing
     * 
     * @return value
     */
    public String getPolicyTypeText() {
        return policyTypeText;
    }

    /** 
     * Set the 'PolicyTypeText' element value. Policy Type, examples: Policy Type. Examples: Privacy_PII, Payment_PCI, Credentialing
     * 
     * @param policyTypeText
     */
    public void setPolicyTypeText(String policyTypeText) {
        this.policyTypeText = policyTypeText;
    }

    /** 
     * Get the 'VersionNumber' element value. Policy version number.  Example: 2.17
     * 
     * @return value
     */
    public BigDecimal getVersionNumber() {
        return versionNumber;
    }

    /** 
     * Set the 'VersionNumber' element value. Policy version number.  Example: 2.17
     * 
     * @param versionNumber
     */
    public void setVersionNumber(BigDecimal versionNumber) {
        this.versionNumber = versionNumber;
    }
}
