
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * place PNR onto individual or multiple queues
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQPCQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_PlacePNR">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:SelectionDetailsTypeI" name="placementOption"/>
 *       &lt;xs:element name="targetDetails" maxOccurs="10">
 *         &lt;!-- Reference to inner class TargetDetails -->
 *       &lt;/xs:element>
 *       &lt;xs:element type="ns:ReservationControlInformationTypeI" name="recordLocator"/>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueuePlacePNR implements Serializable
{
    private SelectionDetailsTypeI placementOption;
    private List<TargetDetails> targetDetailList = new ArrayList<TargetDetails>();
    private ReservationControlInformationTypeI recordLocator;

    /** 
     * Get the 'placementOption' element value. specify the type of placement to be done queue place on queue  queue place on another queue  queue place off queue
     * 
     * @return value
     */
    public SelectionDetailsTypeI getPlacementOption() {
        return placementOption;
    }

    /** 
     * Set the 'placementOption' element value. specify the type of placement to be done queue place on queue  queue place on another queue  queue place off queue
     * 
     * @param placementOption
     */
    public void setPlacementOption(SelectionDetailsTypeI placementOption) {
        this.placementOption = placementOption;
    }

    /** 
     * Get the list of 'targetDetails' element items.
     * 
     * @return list
     */
    public List<TargetDetails> getTargetDetailList() {
        return targetDetailList;
    }

    /** 
     * Set the list of 'targetDetails' element items.
     * 
     * @param list
     */
    public void setTargetDetailList(List<TargetDetails> list) {
        targetDetailList = list;
    }

    /** 
     * Get the 'recordLocator' element value. contains the record locator to be queue placed
     * 
     * @return value
     */
    public ReservationControlInformationTypeI getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'recordLocator' element value. contains the record locator to be queue placed
     * 
     * @param recordLocator
     */
    public void setRecordLocator(
            ReservationControlInformationTypeI recordLocator) {
        this.recordLocator = recordLocator;
    }
    /** 
     * provides upto 10 target offices where the PNR/Msg can be queue placed to
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQPCQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="targetDetails" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AdditionalBusinessSourceInformationType" name="targetOffice"/>
     *       &lt;xs:element type="ns:QueueInformationTypeI" name="queueNumber" minOccurs="0"/>
     *       &lt;xs:element type="ns:SubQueueInformationTypeI" name="categoryDetails" minOccurs="0"/>
     *       &lt;xs:element type="ns:StructuredDateTimeInformationType" name="placementDate" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TargetDetails implements Serializable
    {
        private AdditionalBusinessSourceInformationType targetOffice;
        private QueueInformationTypeI queueNumber;
        private SubQueueInformationTypeI categoryDetails;
        private StructuredDateTimeInformationType placementDate;

        /** 
         * Get the 'targetOffice' element value. used to specify the target office for which the queue count is to be displayed
         * 
         * @return value
         */
        public AdditionalBusinessSourceInformationType getTargetOffice() {
            return targetOffice;
        }

        /** 
         * Set the 'targetOffice' element value. used to specify the target office for which the queue count is to be displayed
         * 
         * @param targetOffice
         */
        public void setTargetOffice(
                AdditionalBusinessSourceInformationType targetOffice) {
            this.targetOffice = targetOffice;
        }

        /** 
         * Get the 'queueNumber' element value. used to specify the queue if required
         * 
         * @return value
         */
        public QueueInformationTypeI getQueueNumber() {
            return queueNumber;
        }

        /** 
         * Set the 'queueNumber' element value. used to specify the queue if required
         * 
         * @param queueNumber
         */
        public void setQueueNumber(QueueInformationTypeI queueNumber) {
            this.queueNumber = queueNumber;
        }

        /** 
         * Get the 'categoryDetails' element value. used to select the category
         * 
         * @return value
         */
        public SubQueueInformationTypeI getCategoryDetails() {
            return categoryDetails;
        }

        /** 
         * Set the 'categoryDetails' element value. used to select the category
         * 
         * @param categoryDetails
         */
        public void setCategoryDetails(SubQueueInformationTypeI categoryDetails) {
            this.categoryDetails = categoryDetails;
        }

        /** 
         * Get the 'placementDate' element value. used to pass the target date/time if not default
         * 
         * @return value
         */
        public StructuredDateTimeInformationType getPlacementDate() {
            return placementDate;
        }

        /** 
         * Set the 'placementDate' element value. used to pass the target date/time if not default
         * 
         * @param placementDate
         */
        public void setPlacementDate(
                StructuredDateTimeInformationType placementDate) {
            this.placementDate = placementDate;
        }
    }
}
