
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * remove items from queue
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMDQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Queue_RemoveItem">
 *   &lt;xs:complexType>
 *     &lt;xs:sequence>
 *       &lt;xs:element type="ns:SelectionDetailsTypeI" name="removalOption"/>
 *       &lt;xs:element name="targetDetails" maxOccurs="3">
 *         &lt;!-- Reference to inner class TargetDetails -->
 *       &lt;/xs:element>
 *     &lt;/xs:sequence>
 *   &lt;/xs:complexType>
 * &lt;/xs:element>
 * </pre>
 */
public class QueueRemoveItem implements Serializable
{
    private SelectionDetailsTypeI1 removalOption;
    private List<TargetDetails> targetDetailList = new ArrayList<TargetDetails>();

    /** 
     * Get the 'removalOption' element value. determine the target of the removal ordinary queue Ticketing queue option queue
     * 
     * @return value
     */
    public SelectionDetailsTypeI1 getRemovalOption() {
        return removalOption;
    }

    /** 
     * Set the 'removalOption' element value. determine the target of the removal ordinary queue Ticketing queue option queue
     * 
     * @param removalOption
     */
    public void setRemovalOption(SelectionDetailsTypeI1 removalOption) {
        this.removalOption = removalOption;
    }

    /** 
     * Get the list of 'targetDetails' element items.
     * 
     * @return list
     */
    public List<TargetDetails> getTargetDetailList() {
        return targetDetailList;
    }

    /** 
     * Set the list of 'targetDetails' element items.
     * 
     * @param list
     */
    public void setTargetDetailList(List<TargetDetails> list) {
        targetDetailList = list;
    }
    /** 
     * used to specify the different targets for the removals
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://xml.amadeus.com/QUQMDQ_03_1_1A" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="targetDetails" maxOccurs="3">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AdditionalBusinessSourceInformationType" name="targetOffice"/>
     *       &lt;xs:element type="ns:QueueInformationTypeI" name="queueNumber" minOccurs="0"/>
     *       &lt;xs:element type="ns:SubQueueInformationTypeI" name="categoryDetails" minOccurs="0"/>
     *       &lt;xs:element type="ns:StructuredDateTimeInformationType" name="placementDate" minOccurs="0"/>
     *       &lt;xs:element type="ns:ReservationControlInformationTypeI" name="recordLocator" minOccurs="0" maxOccurs="300"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TargetDetails implements Serializable
    {
        private AdditionalBusinessSourceInformationType1 targetOffice;
        private QueueInformationTypeI1 queueNumber;
        private SubQueueInformationTypeI1 categoryDetails;
        private StructuredDateTimeInformationType1 placementDate;
        private List<ReservationControlInformationTypeI1> recordLocatorList = new ArrayList<ReservationControlInformationTypeI1>();

        /** 
         * Get the 'targetOffice' element value. used to specify the target office for which the queue removal is to be done
         * 
         * @return value
         */
        public AdditionalBusinessSourceInformationType1 getTargetOffice() {
            return targetOffice;
        }

        /** 
         * Set the 'targetOffice' element value. used to specify the target office for which the queue removal is to be done
         * 
         * @param targetOffice
         */
        public void setTargetOffice(
                AdditionalBusinessSourceInformationType1 targetOffice) {
            this.targetOffice = targetOffice;
        }

        /** 
         * Get the 'queueNumber' element value. used to specify the queue if required
         * 
         * @return value
         */
        public QueueInformationTypeI1 getQueueNumber() {
            return queueNumber;
        }

        /** 
         * Set the 'queueNumber' element value. used to specify the queue if required
         * 
         * @param queueNumber
         */
        public void setQueueNumber(QueueInformationTypeI1 queueNumber) {
            this.queueNumber = queueNumber;
        }

        /** 
         * Get the 'categoryDetails' element value. used to select the category
         * 
         * @return value
         */
        public SubQueueInformationTypeI1 getCategoryDetails() {
            return categoryDetails;
        }

        /** 
         * Set the 'categoryDetails' element value. used to select the category
         * 
         * @param categoryDetails
         */
        public void setCategoryDetails(SubQueueInformationTypeI1 categoryDetails) {
            this.categoryDetails = categoryDetails;
        }

        /** 
         * Get the 'placementDate' element value. used to pass the target date/time if not default
         * 
         * @return value
         */
        public StructuredDateTimeInformationType1 getPlacementDate() {
            return placementDate;
        }

        /** 
         * Set the 'placementDate' element value. used to pass the target date/time if not default
         * 
         * @param placementDate
         */
        public void setPlacementDate(
                StructuredDateTimeInformationType1 placementDate) {
            this.placementDate = placementDate;
        }

        /** 
         * Get the list of 'recordLocator' element items. contains the record locators to be removed from the queue being targeted
         * 
         * @return list
         */
        public List<ReservationControlInformationTypeI1> getRecordLocatorList() {
            return recordLocatorList;
        }

        /** 
         * Set the list of 'recordLocator' element items. contains the record locators to be removed from the queue being targeted
         * 
         * @param list
         */
        public void setRecordLocatorList(
                List<ReservationControlInformationTypeI1> list) {
            recordLocatorList = list;
        }
    }
}
