
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Order Create request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BookingRefType" name="BookingRef" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ChangeOrderType" name="ChangeOrder" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DataListsType" name="DataLists" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MetadataType" name="Metadata" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderType" name="Order" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ResponseParametersType" name="OrderChangeParameters" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroup" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PaymentInfoType" name="PaymentInfo" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestType implements Serializable
{
    private List<BookingRefType> bookingRefList = new ArrayList<BookingRefType>();
    private ChangeOrderType changeOrder;
    private DataListsType dataLists;
    private MetadataType metadata;
    private OrderType order;
    private ResponseParametersType orderChangeParameters;
    private List<PaxGroupType> paxGroupList = new ArrayList<PaxGroupType>();
    private List<PaymentInfoType> paymentInfoList = new ArrayList<PaymentInfoType>();

    /** 
     * Get the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @return list
     */
    public List<BookingRefType> getBookingRefList() {
        return bookingRefList;
    }

    /** 
     * Set the list of 'BookingRef' element items. Information related to a booking or reservation.
     * 
     * @param list
     */
    public void setBookingRefList(List<BookingRefType> list) {
        bookingRefList = list;
    }

    /** 
     * Get the 'ChangeOrder' element value. Contains a choice of functions to update and Order including Update Order Item, Update Passenger, and Accept Reprice Order.
     * 
     * @return value
     */
    public ChangeOrderType getChangeOrder() {
        return changeOrder;
    }

    /** 
     * Set the 'ChangeOrder' element value. Contains a choice of functions to update and Order including Update Order Item, Update Passenger, and Accept Reprice Order.
     * 
     * @param changeOrder
     */
    public void setChangeOrder(ChangeOrderType changeOrder) {
        this.changeOrder = changeOrder;
    }

    /** 
     * Get the 'DataLists' element value. Data List definition for this message.
     * 
     * @return value
     */
    public DataListsType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data List definition for this message.
     * 
     * @param dataLists
     */
    public void setDataLists(DataListsType dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'Metadata' element value. Message wide metadata information.
     * 
     * @return value
     */
    public MetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Message wide metadata information.
     * 
     * @param metadata
     */
    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Order' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @return value
     */
    public OrderType getOrder() {
        return order;
    }

    /** 
     * Set the 'Order' element value. A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services).
     * 
     * @param order
     */
    public void setOrder(OrderType order) {
        this.order = order;
    }

    /** 
     * Get the 'OrderChangeParameters' element value. Information related to how response results should be returned.
     * 
     * @return value
     */
    public ResponseParametersType getOrderChangeParameters() {
        return orderChangeParameters;
    }

    /** 
     * Set the 'OrderChangeParameters' element value. Information related to how response results should be returned.
     * 
     * @param orderChangeParameters
     */
    public void setOrderChangeParameters(
            ResponseParametersType orderChangeParameters) {
        this.orderChangeParameters = orderChangeParameters;
    }

    /** 
     * Get the list of 'PaxGroup' element items. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return list
     */
    public List<PaxGroupType> getPaxGroupList() {
        return paxGroupList;
    }

    /** 
     * Set the list of 'PaxGroup' element items. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param list
     */
    public void setPaxGroupList(List<PaxGroupType> list) {
        paxGroupList = list;
    }

    /** 
     * Get the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @return list
     */
    public List<PaymentInfoType> getPaymentInfoList() {
        return paymentInfoList;
    }

    /** 
     * Set the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @param list
     */
    public void setPaymentInfoList(List<PaymentInfoType> list) {
        paymentInfoList = list;
    }
}
