
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to how response results should be returned.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseParametersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CurParameterType" name="CurParameter" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:boolean" name="InventoryGuaranteeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasurementSystemCodeContentType" name="MeasurementSystemCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ReasonCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentMethodType" name="RefundFOPPref" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseParametersType implements Serializable
{
    private List<CurParameterType> curParameterList = new ArrayList<CurParameterType>();
    private Boolean inventoryGuaranteeInd;
    private MeasurementSystemCodeContentType measurementSystemCode;
    private String reasonCode;
    private PaymentMethodType refundFOPPref;
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();

    /** 
     * Get the list of 'CurParameter' element items. Currency related parameters intended to influence which currency the shopping results are displayed in.
     * 
     * @return list
     */
    public List<CurParameterType> getCurParameterList() {
        return curParameterList;
    }

    /** 
     * Set the list of 'CurParameter' element items. Currency related parameters intended to influence which currency the shopping results are displayed in.
     * 
     * @param list
     */
    public void setCurParameterList(List<CurParameterType> list) {
        curParameterList = list;
    }

    /** 
     * Get the 'InventoryGuaranteeInd' element value. When TRUE, inventory guarantee is requested for applicable optional services.
     * 
     * @return value
     */
    public Boolean getInventoryGuaranteeInd() {
        return inventoryGuaranteeInd;
    }

    /** 
     * Set the 'InventoryGuaranteeInd' element value. When TRUE, inventory guarantee is requested for applicable optional services.
     * 
     * @param inventoryGuaranteeInd
     */
    public void setInventoryGuaranteeInd(Boolean inventoryGuaranteeInd) {
        this.inventoryGuaranteeInd = inventoryGuaranteeInd;
    }

    /** 
     * Get the 'MeasurementSystemCode' element value. Measurement system code.  Examples: Imperial, Metric
     * 
     * @return value
     */
    public MeasurementSystemCodeContentType getMeasurementSystemCode() {
        return measurementSystemCode;
    }

    /** 
     * Set the 'MeasurementSystemCode' element value. Measurement system code.  Examples: Imperial, Metric
     * 
     * @param measurementSystemCode
     */
    public void setMeasurementSystemCode(
            MeasurementSystemCodeContentType measurementSystemCode) {
        this.measurementSystemCode = measurementSystemCode;
    }

    /** 
     * Get the 'ReasonCode' element value. Reason for change. Encoding scheme IATA PADIS REA
     * 
     * @return value
     */
    public String getReasonCode() {
        return reasonCode;
    }

    /** 
     * Set the 'ReasonCode' element value. Reason for change. Encoding scheme IATA PADIS REA
     * 
     * @param reasonCode
     */
    public void setReasonCode(String reasonCode) {
        this.reasonCode = reasonCode;
    }

    /** 
     * Get the 'RefundFOPPref' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @return value
     */
    public PaymentMethodType getRefundFOPPref() {
        return refundFOPPref;
    }

    /** 
     * Set the 'RefundFOPPref' element value. A form of procedure for the payment of goods or services, plus any transactional information specific to the payment method other than the amount.
     * 
     * @param refundFOPPref
     */
    public void setRefundFOPPref(PaymentMethodType refundFOPPref) {
        this.refundFOPPref = refundFOPPref;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }
}
