
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A company that partners with a manufacturer or producer to market and sell the manufacturer's products, services, or technologies.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetailPartnerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ContactInfoRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RetailPartnerID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RetailPartnerType implements Serializable
{
    private List<String> contactInfoRefIDList = new ArrayList<String>();
    private String name;
    private String retailPartnerID;

    /** 
     * Get the list of 'ContactInfoRefID' element items. Reference to a ContactInfoID
     * 
     * @return list
     */
    public List<String> getContactInfoRefIDList() {
        return contactInfoRefIDList;
    }

    /** 
     * Set the list of 'ContactInfoRefID' element items. Reference to a ContactInfoID
     * 
     * @param list
     */
    public void setContactInfoRefIDList(List<String> list) {
        contactInfoRefIDList = list;
    }

    /** 
     * Get the 'Name' element value. Retail partner name.
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'Name' element value. Retail partner name.
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'RetailPartnerID' element value. Unique Retailer ID
     * 
     * @return value
     */
    public String getRetailPartnerID() {
        return retailPartnerID;
    }

    /** 
     * Set the 'RetailPartnerID' element value. Unique Retailer ID
     * 
     * @param retailPartnerID
     */
    public void setRetailPartnerID(String retailPartnerID) {
        this.retailPartnerID = retailPartnerID;
    }
}
