
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * For service bundle selection - only to be used for bundles with optional choices (e.g. pick 2 out of 4)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SelectedBundleServicesType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="SelectedServiceDefinitionRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="SelectedServiceRefID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SelectedBundleServicesType implements Serializable
{
    private List<String> selectedServiceDefinitionRefIDList = new ArrayList<String>();
    private String selectedServiceRefID;

    /** 
     * Get the list of 'SelectedServiceDefinitionRefID' element items. Reference to the Service Definition selected by the Passenger as part of a service bundle.
     * 
     * @return list
     */
    public List<String> getSelectedServiceDefinitionRefIDList() {
        return selectedServiceDefinitionRefIDList;
    }

    /** 
     * Set the list of 'SelectedServiceDefinitionRefID' element items. Reference to the Service Definition selected by the Passenger as part of a service bundle.
     * 
     * @param list
     */
    public void setSelectedServiceDefinitionRefIDList(List<String> list) {
        selectedServiceDefinitionRefIDList = list;
    }

    /** 
     * Get the 'SelectedServiceRefID' element value. Reference to the Service (within the Offer Item) form which the Service Bundle is contained.
     * 
     * @return value
     */
    public String getSelectedServiceRefID() {
        return selectedServiceRefID;
    }

    /** 
     * Set the 'SelectedServiceRefID' element value. Reference to the Service (within the Offer Item) form which the Service Bundle is contained.
     * 
     * @param selectedServiceRefID
     */
    public void setSelectedServiceRefID(String selectedServiceRefID) {
        this.selectedServiceRefID = selectedServiceRefID;
    }
}
