
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs).   Each Offer selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and â€œa-la-carteâ€&#157; Offers would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SelectedOfferType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OfferRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SelectedOfferItemType" name="SelectedOfferItem" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ShoppingResponseRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="TotalOfferPriceAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SelectedOfferType implements Serializable
{
    private String offerRefID;
    private String ownerCode;
    private List<SelectedOfferItemType> selectedOfferItemList = new ArrayList<SelectedOfferItemType>();
    private String shoppingResponseRefID;
    private AmountType totalOfferPriceAmount;

    /** 
     * Get the 'OfferRefID' element value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @return value
     */
    public String getOfferRefID() {
        return offerRefID;
    }

    /** 
     * Set the 'OfferRefID' element value. Reference to the OfferID of the selected Offer (either a standard Offer or an a-la-carte Offer) returned in a previous shopping response.
     * 
     * @param offerRefID
     */
    public void setOfferRefID(String offerRefID) {
        this.offerRefID = offerRefID;
    }

    /** 
     * Get the 'OwnerCode' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Designator of Airline that owns/ assigned these IDs. Examples: BA
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the list of 'SelectedOfferItem' element items. OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items or different seat locations.   As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems. Optional OfferItems may then be appended as further items selected by the Passenger.   OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItemâ€™s associations (to passengers and/or flight segments).
     * 
     * @return list
     */
    public List<SelectedOfferItemType> getSelectedOfferItemList() {
        return selectedOfferItemList;
    }

    /** 
     * Set the list of 'SelectedOfferItem' element items. OfferItem selected by the Passenger for inclusion in the requested Order. Repeat occurrence of OfferItem (once per passenger) if different passengers want to select different service options, different quantities of a-la-carte items or different seat locations.   As a minimum, all mandatory OfferItems from a desired Offer should be explicitly defined within these selections and should repeat the same Passenger and Flight Segment associations defined in the originating OfferItems. Optional OfferItems may then be appended as further items selected by the Passenger.   OfferItems from the originating Offers may take on two different forms, which in turn drives how the ALaCarteSelection element is to be used - If the OfferItem referenced comes originally from an a-la-carte Offer, then the use of the ALaCarteSelection element should be used to defined the Quantity of said OfferItem. On the other hand, if the OfferItem comes from a standard type of Offer in the previous shopping response, the ALaCarteSelection element should not be used, as the quantity is explicitly driven by what is defined in that OfferItemâ€™s associations (to passengers and/or flight segments).
     * 
     * @param list
     */
    public void setSelectedOfferItemList(List<SelectedOfferItemType> list) {
        selectedOfferItemList = list;
    }

    /** 
     * Get the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @return value
     */
    public String getShoppingResponseRefID() {
        return shoppingResponseRefID;
    }

    /** 
     * Set the 'ShoppingResponseRefID' element value. Reference to unique shopping session response ID, as provided in the airline's previous shopping response.
     * 
     * @param shoppingResponseRefID
     */
    public void setShoppingResponseRefID(String shoppingResponseRefID) {
        this.shoppingResponseRefID = shoppingResponseRefID;
    }

    /** 
     * Get the 'TotalOfferPriceAmount' element value. The total price for all selected Offer Items (and respective quantities) for all passengers and segments associated with the respective Offer(s), as calculated by the seller system. Without adding any optional Offer Items, the value of this TotalOfferPrice should be that of the TotalPrice of the Offer(s) being referenced.
     * 
     * @return value
     */
    public AmountType getTotalOfferPriceAmount() {
        return totalOfferPriceAmount;
    }

    /** 
     * Set the 'TotalOfferPriceAmount' element value. The total price for all selected Offer Items (and respective quantities) for all passengers and segments associated with the respective Offer(s), as calculated by the seller system. Without adding any optional Offer Items, the value of this TotalOfferPrice should be that of the TotalPrice of the Offer(s) being referenced.
     * 
     * @param totalOfferPriceAmount
     */
    public void setTotalOfferPriceAmount(AmountType totalOfferPriceAmount) {
        this.totalOfferPriceAmount = totalOfferPriceAmount;
    }
}
