
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Selection of specific seat location, as provided in seat availability messages.  When used, only a single Passenger must be referenced for a single Segment.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SelectedSeatType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ColumnID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="SeatRowNumber" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SelectedSeatType implements Serializable
{
    private String columnID;
    private BigDecimal seatRowNumber;

    /** 
     * Get the 'ColumnID' element value. Seat column to identify a particular seat position on an aircraft.
     * 
     * @return value
     */
    public String getColumnID() {
        return columnID;
    }

    /** 
     * Set the 'ColumnID' element value. Seat column to identify a particular seat position on an aircraft.
     * 
     * @param columnID
     */
    public void setColumnID(String columnID) {
        this.columnID = columnID;
    }

    /** 
     * Get the 'SeatRowNumber' element value. Seat Row number. Example: 2
     * 
     * @return value
     */
    public BigDecimal getSeatRowNumber() {
        return seatRowNumber;
    }

    /** 
     * Set the 'SeatRowNumber' element value. Seat Row number. Example: 2
     * 
     * @param seatRowNumber
     */
    public void setSeatRowNumber(BigDecimal seatRowNumber) {
        this.seatRowNumber = seatRowNumber;
    }
}
