
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceAssociationsType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatonLegType" name="SelectedSeat" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceDefinitionRefType" name="ServiceDefinitionRef" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceAssociationsType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PAX_SEGMENT_REF_ID_CHOICE = 0;
    private static final int SELECTED_SEAT_CHOICE = 1;
    private static final int SERVICE_DEFINITION_REF_CHOICE = 2;
    private String paxSegmentRefID;
    private SeatonLegType selectedSeat;
    private ServiceDefinitionRefType serviceDefinitionRef;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PaxSegmentRefID is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaxSegmentRefID() {
        return choiceSelect == PAX_SEGMENT_REF_ID_CHOICE;
    }

    /** 
     * Get the 'PaxSegmentRefID' element value. Reference to a Passenger Segment ID within this message.
     * 
     * @return value
     */
    public String getPaxSegmentRefID() {
        return paxSegmentRefID;
    }

    /** 
     * Set the 'PaxSegmentRefID' element value. Reference to a Passenger Segment ID within this message.
     * 
     * @param paxSegmentRefID
     */
    public void setPaxSegmentRefID(String paxSegmentRefID) {
        setChoiceSelect(PAX_SEGMENT_REF_ID_CHOICE);
        this.paxSegmentRefID = paxSegmentRefID;
    }

    /** 
     * Check if SelectedSeat is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSelectedSeat() {
        return choiceSelect == SELECTED_SEAT_CHOICE;
    }

    /** 
     * Get the 'SelectedSeat' element value. A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg.
     * 
     * @return value
     */
    public SeatonLegType getSelectedSeat() {
        return selectedSeat;
    }

    /** 
     * Set the 'SelectedSeat' element value. A sitting place for a passenger or crew in a cabin compartment on a Dated Operating Leg.
     * 
     * @param selectedSeat
     */
    public void setSelectedSeat(SeatonLegType selectedSeat) {
        setChoiceSelect(SELECTED_SEAT_CHOICE);
        this.selectedSeat = selectedSeat;
    }

    /** 
     * Check if ServiceDefinitionRef is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceDefinitionRef() {
        return choiceSelect == SERVICE_DEFINITION_REF_CHOICE;
    }

    /** 
     * Get the 'ServiceDefinitionRef' element value. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @return value
     */
    public ServiceDefinitionRefType getServiceDefinitionRef() {
        return serviceDefinitionRef;
    }

    /** 
     * Set the 'ServiceDefinitionRef' element value. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @param serviceDefinitionRef
     */
    public void setServiceDefinitionRef(
            ServiceDefinitionRefType serviceDefinitionRef) {
        setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
        this.serviceDefinitionRef = serviceDefinitionRef;
    }
}
