
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A set of services offered for sale as a single service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceBundleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:QtyType" name="MaximumServiceQty" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDefinitionRefID" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceBundleType implements Serializable
{
    private QtyType maximumServiceQty;
    private List<String> serviceDefinitionRefIDList = new ArrayList<String>();

    /** 
     * Get the 'MaximumServiceQty' element value. The maximum number of service definitions that may be selected from those in the bundle.
     * 
     * @return value
     */
    public QtyType getMaximumServiceQty() {
        return maximumServiceQty;
    }

    /** 
     * Set the 'MaximumServiceQty' element value. The maximum number of service definitions that may be selected from those in the bundle.
     * 
     * @param maximumServiceQty
     */
    public void setMaximumServiceQty(QtyType maximumServiceQty) {
        this.maximumServiceQty = maximumServiceQty;
    }

    /** 
     * Get the list of 'ServiceDefinitionRefID' element items. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @return list
     */
    public List<String> getServiceDefinitionRefIDList() {
        return serviceDefinitionRefIDList;
    }

    /** 
     * Set the list of 'ServiceDefinitionRefID' element items. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @param list
     */
    public void setServiceDefinitionRefIDList(List<String> list) {
        serviceDefinitionRefIDList = list;
    }
}
