
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;

/** 
 * Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceDefinitionRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDefinitionRefID" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceDefinitionRefType implements Serializable
{
    private String paxSegmentRefID;
    private String serviceDefinitionRefID;

    /** 
     * Get the 'PaxSegmentRefID' element value. References a Passenger Segment ID within this message.
     * 
     * @return value
     */
    public String getPaxSegmentRefID() {
        return paxSegmentRefID;
    }

    /** 
     * Set the 'PaxSegmentRefID' element value. References a Passenger Segment ID within this message.
     * 
     * @param paxSegmentRefID
     */
    public void setPaxSegmentRefID(String paxSegmentRefID) {
        this.paxSegmentRefID = paxSegmentRefID;
    }

    /** 
     * Get the 'ServiceDefinitionRefID' element value. References a Service Definition ID within this message.
     * 
     * @return value
     */
    public String getServiceDefinitionRefID() {
        return serviceDefinitionRefID;
    }

    /** 
     * Set the 'ServiceDefinitionRefID' element value. References a Service Definition ID within this message.
     * 
     * @param serviceDefinitionRefID
     */
    public void setServiceDefinitionRefID(String serviceDefinitionRefID) {
        this.serviceDefinitionRefID = serviceDefinitionRefID;
    }
}
