
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderChange.rq;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Baggage weight allowance with application information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderChangeRQ" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WeightAllowanceType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ApplicableBagText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ApplicablePartyText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:MeasureType" name="MaximumWeightMeasure" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class WeightAllowanceType implements Serializable
{
    private String applicableBagText;
    private String applicablePartyText;
    private List<String> descTextList = new ArrayList<String>();
    private MeasureType maximumWeightMeasure;

    /** 
     * Get the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @return value
     */
    public String getApplicableBagText() {
        return applicableBagText;
    }

    /** 
     * Set the 'ApplicableBagText' element value. Applicable bag type.  Examples: Carry-On, 1st Checked Bag, 2nd Checked Bag
     * 
     * @param applicableBagText
     */
    public void setApplicableBagText(String applicableBagText) {
        this.applicableBagText = applicableBagText;
    }

    /** 
     * Get the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @return value
     */
    public String getApplicablePartyText() {
        return applicablePartyText;
    }

    /** 
     * Set the 'ApplicablePartyText' element value. Baggage weight restriction application.  Examples: Party, Traveler. Party applies to all Travelers.
     * 
     * @param applicablePartyText
     */
    public void setApplicablePartyText(String applicablePartyText) {
        this.applicablePartyText = applicablePartyText;
    }

    /** 
     * Get the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @return list
     */
    public List<String> getDescTextList() {
        return descTextList;
    }

    /** 
     * Set the list of 'DescText' element items. Baggage Allowance description and additional information.
     * 
     * @param list
     */
    public void setDescTextList(List<String> list) {
        descTextList = list;
    }

    /** 
     * Get the 'MaximumWeightMeasure' element value. Maximum weight value and unit of measure.  Example: 50
     * 
     * @return value
     */
    public MeasureType getMaximumWeightMeasure() {
        return maximumWeightMeasure;
    }

    /** 
     * Set the 'MaximumWeightMeasure' element value. Maximum weight value and unit of measure.  Example: 50
     * 
     * @param maximumWeightMeasure
     */
    public void setMaximumWeightMeasure(MeasureType maximumWeightMeasure) {
        this.maximumWeightMeasure = maximumWeightMeasure;
    }
}
