
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * The carrier whose baggage allowances and charges apply.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BDC_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BagRuleCodeContentType" name="BagRuleCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BDC_AnalysisResultCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BDC_ReasonText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CarrierDesigCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CarrierName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BDCType implements Serializable
{
    private BagRuleCodeContentType bagRuleCode;
    private String BDCAnalysisResultCode;
    private String BDCReasonText;
    private String carrierDesigCode;
    private String carrierName;

    /** 
     * Get the 'BagRuleCode' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @return value
     */
    public BagRuleCodeContentType getBagRuleCode() {
        return bagRuleCode;
    }

    /** 
     * Set the 'BagRuleCode' element value. US Department of Transportation (DOT) Reservation or Disclosure baggage rule. Examples: Y, Disclosure AND US DOT Reservation
     * 
     * @param bagRuleCode
     */
    public void setBagRuleCode(BagRuleCodeContentType bagRuleCode) {
        this.bagRuleCode = bagRuleCode;
    }

    /** 
     * Get the 'BDC_AnalysisResultCode' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code in the AirlineID element.  Encoding Scheme: IATA PADIS Code List for data element RES.
     * 
     * @return value
     */
    public String getBDCAnalysisResultCode() {
        return BDCAnalysisResultCode;
    }

    /** 
     * Set the 'BDC_AnalysisResultCode' element value. In concert with BaggageDeterminingCarrier data field, specifies the reason for the carrier code in the AirlineID element.  Encoding Scheme: IATA PADIS Code List for data element RES.
     * 
     * @param BDCAnalysisResultCode
     */
    public void setBDCAnalysisResultCode(String BDCAnalysisResultCode) {
        this.BDCAnalysisResultCode = BDCAnalysisResultCode;
    }

    /** 
     * Get the 'BDC_ReasonText' element value. Reason for selection of the Baggage Determining Carrier.  Examples: Regulatory (application of regulation or resolution), Deferral (deferral by ORA), Bilateral (bilateral agreement).
     * 
     * @return value
     */
    public String getBDCReasonText() {
        return BDCReasonText;
    }

    /** 
     * Set the 'BDC_ReasonText' element value. Reason for selection of the Baggage Determining Carrier.  Examples: Regulatory (application of regulation or resolution), Deferral (deferral by ORA), Bilateral (bilateral agreement).
     * 
     * @param BDCReasonText
     */
    public void setBDCReasonText(String BDCReasonText) {
        this.BDCReasonText = BDCReasonText;
    }

    /** 
     * Get the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getCarrierDesigCode() {
        return carrierDesigCode;
    }

    /** 
     * Set the 'CarrierDesigCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param carrierDesigCode
     */
    public void setCarrierDesigCode(String carrierDesigCode) {
        this.carrierDesigCode = carrierDesigCode;
    }

    /** 
     * Get the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @return value
     */
    public String getCarrierName() {
        return carrierName;
    }

    /** 
     * Set the 'CarrierName' element value. Commercial name of the carrier.
     * 
     * @param carrierName
     */
    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }
}
