
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * The electronic or geographic address which a party has provided as the contact channel. For example, contact email, contact postal address, contact phone number.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContactInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ContactInfoID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ContactRefusedInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ContactTypeText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:EmailAddressType" name="EmailAddress" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:Org1Type" name="Employer" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="IndividualRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:IndividualType" name="Individual" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OtherAddressType" name="OtherAddress" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PhoneType" name="Phone" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PostalAddressType" name="PostalAddress" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContactInfoType implements Serializable
{
    private String contactInfoID;
    private Boolean contactRefusedInd;
    private String contactTypeText;
    private List<EmailAddressType> emailAddressList = new ArrayList<EmailAddressType>();
    private Org1Type employer;
    private String individualRefID;
    private IndividualType individual;
    private List<OtherAddressType> otherAddressList = new ArrayList<OtherAddressType>();
    private List<PhoneType> phoneList = new ArrayList<PhoneType>();
    private List<PostalAddressType> postalAddressList = new ArrayList<PostalAddressType>();

    /** 
     * Get the 'ContactInfoID' element value. Uniquely Identifies a set of Contact Information, within the context of one message.
     * 
     * @return value
     */
    public String getContactInfoID() {
        return contactInfoID;
    }

    /** 
     * Set the 'ContactInfoID' element value. Uniquely Identifies a set of Contact Information, within the context of one message.
     * 
     * @param contactInfoID
     */
    public void setContactInfoID(String contactInfoID) {
        this.contactInfoID = contactInfoID;
    }

    /** 
     * Get the 'ContactRefusedInd' element value. When TRUE, Contact Information was refused to be provided.
     * 
     * @return value
     */
    public Boolean getContactRefusedInd() {
        return contactRefusedInd;
    }

    /** 
     * Set the 'ContactRefusedInd' element value. When TRUE, Contact Information was refused to be provided.
     * 
     * @param contactRefusedInd
     */
    public void setContactRefusedInd(Boolean contactRefusedInd) {
        this.contactRefusedInd = contactRefusedInd;
    }

    /** 
     * Get the 'ContactTypeText' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
     * 
     * @return value
     */
    public String getContactTypeText() {
        return contactTypeText;
    }

    /** 
     * Set the 'ContactTypeText' element value. Classification for a particular set of contact information (e.g. Primary, Payment, etc.)
     * 
     * @param contactTypeText
     */
    public void setContactTypeText(String contactTypeText) {
        this.contactTypeText = contactTypeText;
    }

    /** 
     * Get the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
     * 
     * @return list
     */
    public List<EmailAddressType> getEmailAddressList() {
        return emailAddressList;
    }

    /** 
     * Set the list of 'EmailAddress' element items. The email address which should be used for contact purposes.
     * 
     * @param list
     */
    public void setEmailAddressList(List<EmailAddressType> list) {
        emailAddressList = list;
    }

    /** 
     * Get the 'Employer' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @return value
     */
    public Org1Type getEmployer() {
        return employer;
    }

    /** 
     * Set the 'Employer' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @param employer
     */
    public void setEmployer(Org1Type employer) {
        this.employer = employer;
    }

    /** 
     * Get the 'IndividualRefID' element value. Reference to Individual instance(s)
     * 
     * @return value
     */
    public String getIndividualRefID() {
        return individualRefID;
    }

    /** 
     * Set the 'IndividualRefID' element value. Reference to Individual instance(s)
     * 
     * @param individualRefID
     */
    public void setIndividualRefID(String individualRefID) {
        this.individualRefID = individualRefID;
    }

    /** 
     * Get the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @return value
     */
    public IndividualType getIndividual() {
        return individual;
    }

    /** 
     * Set the 'Individual' element value. A single human being as distinct from a group, class, or family.
     * 
     * @param individual
     */
    public void setIndividual(IndividualType individual) {
        this.individual = individual;
    }

    /** 
     * Get the list of 'OtherAddress' element items. Other Contact Method information. E.g. web site URL, social media handle.
     * 
     * @return list
     */
    public List<OtherAddressType> getOtherAddressList() {
        return otherAddressList;
    }

    /** 
     * Set the list of 'OtherAddress' element items. Other Contact Method information. E.g. web site URL, social media handle.
     * 
     * @param list
     */
    public void setOtherAddressList(List<OtherAddressType> list) {
        otherAddressList = list;
    }

    /** 
     * Get the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * 
     * @return list
     */
    public List<PhoneType> getPhoneList() {
        return phoneList;
    }

    /** 
     * Set the list of 'Phone' element items. A telephone number is a sequence of digits assigned to a fixed-line telephone subscriber station connected to a telephone line or to a wireless electronic telephony device, such as a radio telephone or a mobile telephone, or to other devices for data transmission via the public switched telephone network (PSTN) or other private networks.
     * 
     * @param list
     */
    public void setPhoneList(List<PhoneType> list) {
        phoneList = list;
    }

    /** 
     * Get the list of 'PostalAddress' element items. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @return list
     */
    public List<PostalAddressType> getPostalAddressList() {
        return postalAddressList;
    }

    /** 
     * Set the list of 'PostalAddress' element items. Natural or physical address used for postal service. May be a building address, airport address, etc.
     * 
     * @param list
     */
    public void setPostalAddressList(List<PostalAddressType> list) {
        postalAddressList = list;
    }
}
