
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Airline or Organization from which the associated content originates.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContentOwnerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrgType" name="Org" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ContentOwnerType implements Serializable
{
    private CarrierType carrier;
    private OrgType org;

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @return value
     */
    public OrgType getOrg() {
        return org;
    }

    /** 
     * Set the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @param org
     */
    public void setOrg(OrgType org) {
        this.org = org;
    }
}
