
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * OrderItems which the Airline confirms can be deleted in a subsequent OrderChangeRQ. Optionally, a price differential (e.g. refund amounts) can be added to each OrderItem occurrence being deleted.  Should not be used for 'replace' type functions. In the
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteOrderItemType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="DifferentialAmountDue" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="FeesDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="NewOfferItemDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OrderItemRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="OriginalOrderItemDifferential" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopDifferentialType" name="PenaltyDifferential" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteOrderItemType implements Serializable
{
    private ReshopDifferentialType differentialAmountDue;
    private ReshopDifferentialType feesDifferential;
    private ReshopDifferentialType newOfferItemDifferential;
    private String orderItemRefID;
    private ReshopDifferentialType originalOrderItemDifferential;
    private ReshopDifferentialType penaltyDifferential;

    /** 
     * Get the 'DifferentialAmountDue' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getDifferentialAmountDue() {
        return differentialAmountDue;
    }

    /** 
     * Set the 'DifferentialAmountDue' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param differentialAmountDue
     */
    public void setDifferentialAmountDue(
            ReshopDifferentialType differentialAmountDue) {
        this.differentialAmountDue = differentialAmountDue;
    }

    /** 
     * Get the 'FeesDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getFeesDifferential() {
        return feesDifferential;
    }

    /** 
     * Set the 'FeesDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param feesDifferential
     */
    public void setFeesDifferential(ReshopDifferentialType feesDifferential) {
        this.feesDifferential = feesDifferential;
    }

    /** 
     * Get the 'NewOfferItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getNewOfferItemDifferential() {
        return newOfferItemDifferential;
    }

    /** 
     * Set the 'NewOfferItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param newOfferItemDifferential
     */
    public void setNewOfferItemDifferential(
            ReshopDifferentialType newOfferItemDifferential) {
        this.newOfferItemDifferential = newOfferItemDifferential;
    }

    /** 
     * Get the 'OrderItemRefID' element value.
     * 
     * @return value
     */
    public String getOrderItemRefID() {
        return orderItemRefID;
    }

    /** 
     * Set the 'OrderItemRefID' element value.
     * 
     * @param orderItemRefID
     */
    public void setOrderItemRefID(String orderItemRefID) {
        this.orderItemRefID = orderItemRefID;
    }

    /** 
     * Get the 'OriginalOrderItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getOriginalOrderItemDifferential() {
        return originalOrderItemDifferential;
    }

    /** 
     * Set the 'OriginalOrderItemDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param originalOrderItemDifferential
     */
    public void setOriginalOrderItemDifferential(
            ReshopDifferentialType originalOrderItemDifferential) {
        this.originalOrderItemDifferential = originalOrderItemDifferential;
    }

    /** 
     * Get the 'PenaltyDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @return value
     */
    public ReshopDifferentialType getPenaltyDifferential() {
        return penaltyDifferential;
    }

    /** 
     * Set the 'PenaltyDifferential' element value. Contains the Original Order amount, new Offer amount, penalty details, fees and due by details. It also contains tax information.
     * 
     * @param penaltyDifferential
     */
    public void setPenaltyDifferential(
            ReshopDifferentialType penaltyDifferential) {
        this.penaltyDifferential = penaltyDifferential;
    }
}
