
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * A portion of an itinerary between two consecutive fare construction points.  If the journey has only one fare component, the points of origin and destination are the only fare construction points
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CabinTypeType" name="CabinType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisAppCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCityPairText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:FareRuleType" name="FareRule" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="FareTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxSegmentRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PriceType" name="Price" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PriceClassRefID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RBD_Type" name="RBD" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareComponentType implements Serializable
{
    private CabinTypeType cabinType;
    private String fareBasisAppCode;
    private String fareBasisCityPairText;
    private String fareBasisCode;
    private List<FareRuleType> fareRuleList = new ArrayList<FareRuleType>();
    private String fareTypeCode;
    private List<String> paxSegmentRefIDList = new ArrayList<String>();
    private PriceType price;
    private String priceClassRefID;
    private RBDType RBD;

    /** 
     * Get the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @return value
     */
    public CabinTypeType getCabinType() {
        return cabinType;
    }

    /** 
     * Set the 'CabinType' element value. Type of compartment of an aircraft, offering specific services (e.g. business class, economy).
     * 
     * @param cabinType
     */
    public void setCabinType(CabinTypeType cabinType) {
        this.cabinType = cabinType;
    }

    /** 
     * Get the 'FareBasisAppCode' element value. Indicates how the fare basis was applied.  E.g. Requested, Ticketed, Other.
     * 
     * @return value
     */
    public String getFareBasisAppCode() {
        return fareBasisAppCode;
    }

    /** 
     * Set the 'FareBasisAppCode' element value. Indicates how the fare basis was applied.  E.g. Requested, Ticketed, Other.
     * 
     * @param fareBasisAppCode
     */
    public void setFareBasisAppCode(String fareBasisAppCode) {
        this.fareBasisAppCode = fareBasisAppCode;
    }

    /** 
     * Get the 'FareBasisCityPairText' element value. Identified published fare.  Origin and destination city codes and two character designator of fare owning airline associated with Fare Basis Code.  Example: MIANCEDL
     * 
     * @return value
     */
    public String getFareBasisCityPairText() {
        return fareBasisCityPairText;
    }

    /** 
     * Set the 'FareBasisCityPairText' element value. Identified published fare.  Origin and destination city codes and two character designator of fare owning airline associated with Fare Basis Code.  Example: MIANCEDL
     * 
     * @param fareBasisCityPairText
     */
    public void setFareBasisCityPairText(String fareBasisCityPairText) {
        this.fareBasisCityPairText = fareBasisCityPairText;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare basis code. Example: Y26
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare basis code. Example: Y26
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the list of 'FareRule' element items. Special purchasing rules and restrictions used to differentiate fare levels from one another.
     * 
     * @return list
     */
    public List<FareRuleType> getFareRuleList() {
        return fareRuleList;
    }

    /** 
     * Set the list of 'FareRule' element items. Special purchasing rules and restrictions used to differentiate fare levels from one another.
     * 
     * @param list
     */
    public void setFareRuleList(List<FareRuleType> list) {
        fareRuleList = list;
    }

    /** 
     * Get the 'FareTypeCode' element value. Fare Amount Type Code, ex: ADC (Additional Charge), IT (Tour Inclusive), NOADC (No additional charge).
     * 
     * @return value
     */
    public String getFareTypeCode() {
        return fareTypeCode;
    }

    /** 
     * Set the 'FareTypeCode' element value. Fare Amount Type Code, ex: ADC (Additional Charge), IT (Tour Inclusive), NOADC (No additional charge).
     * 
     * @param fareTypeCode
     */
    public void setFareTypeCode(String fareTypeCode) {
        this.fareTypeCode = fareTypeCode;
    }

    /** 
     * Get the list of 'PaxSegmentRefID' element items. Reference to a Pax Segment ID.
     * 
     * @return list
     */
    public List<String> getPaxSegmentRefIDList() {
        return paxSegmentRefIDList;
    }

    /** 
     * Set the list of 'PaxSegmentRefID' element items. Reference to a Pax Segment ID.
     * 
     * @param list
     */
    public void setPaxSegmentRefIDList(List<String> list) {
        paxSegmentRefIDList = list;
    }

    /** 
     * Get the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @return value
     */
    public PriceType getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. The amount of money expected, required, or given in payment for something.
     * 
     * @param price
     */
    public void setPrice(PriceType price) {
        this.price = price;
    }

    /** 
     * Get the 'PriceClassRefID' element value. A price point within a particular Cabin Type (sometimes referred to as 'Fare Families').
     * 
     * @return value
     */
    public String getPriceClassRefID() {
        return priceClassRefID;
    }

    /** 
     * Set the 'PriceClassRefID' element value. A price point within a particular Cabin Type (sometimes referred to as 'Fare Families').
     * 
     * @param priceClassRefID
     */
    public void setPriceClassRefID(String priceClassRefID) {
        this.priceClassRefID = priceClassRefID;
    }

    /** 
     * Get the 'RBD' element value. Reservation Booking Designator.  A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium, 'D' for Business Discounted.
     * 
     * @return value
     */
    public RBDType getRBD() {
        return RBD;
    }

    /** 
     * Set the 'RBD' element value. Reservation Booking Designator.  A categorization used to facilitate access to inventory, application of filed fares, and to identify cabin entitlement. Identified using a single alpha character. E.g. 'J' for Business Class Premium, 'D' for Business Discounted.
     * 
     * @param RBD
     */
    public void setRBD(RBDType RBD) {
        this.RBD = RBD;
    }
}
