
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Special purchasing rules and restrictions used to differentiate fare levels from one another.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRuleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="InstantPurchaseTypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PenaltyRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="RuleCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="TicketlessInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareRuleType implements Serializable
{
    private String instantPurchaseTypeCode;
    private List<String> penaltyRefIDList = new ArrayList<String>();
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private String ruleCode;
    private Boolean ticketlessInd;

    /** 
     * Get the 'InstantPurchaseTypeCode' element value. Instant purchase type code, Ex: CC (Ticketless purchase immediately charged to credit card) NO (Not an instant purchase) TT (Simultaneous with time of ticketing)  Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type
     * 
     * @return value
     */
    public String getInstantPurchaseTypeCode() {
        return instantPurchaseTypeCode;
    }

    /** 
     * Set the 'InstantPurchaseTypeCode' element value. Instant purchase type code, Ex: CC (Ticketless purchase immediately charged to credit card) NO (Not an instant purchase) TT (Simultaneous with time of ticketing)  Encoding scheme: IATA PADIS Codeset IPT - Instant Purchase Type
     * 
     * @param instantPurchaseTypeCode
     */
    public void setInstantPurchaseTypeCode(String instantPurchaseTypeCode) {
        this.instantPurchaseTypeCode = instantPurchaseTypeCode;
    }

    /** 
     * Get the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @return list
     */
    public List<String> getPenaltyRefIDList() {
        return penaltyRefIDList;
    }

    /** 
     * Set the list of 'PenaltyRefID' element items. Reference to a Penalty ID.
     * 
     * @param list
     */
    public void setPenaltyRefIDList(List<String> list) {
        penaltyRefIDList = list;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'RuleCode' element value. Fare category number as defined by ATPCO.
     * 
     * @return value
     */
    public String getRuleCode() {
        return ruleCode;
    }

    /** 
     * Set the 'RuleCode' element value. Fare category number as defined by ATPCO.
     * 
     * @param ruleCode
     */
    public void setRuleCode(String ruleCode) {
        this.ruleCode = ruleCode;
    }

    /** 
     * Get the 'TicketlessInd' element value. When TRUE, the Fare can be purchased without issuing a ticket.
     * 
     * @return value
     */
    public Boolean getTicketlessInd() {
        return ticketlessInd;
    }

    /** 
     * Set the 'TicketlessInd' element value. When TRUE, the Fare can be purchased without issuing a ticket.
     * 
     * @param ticketlessInd
     */
    public void setTicketlessInd(Boolean ticketlessInd) {
        this.ticketlessInd = ticketlessInd;
    }
}
