
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Enumeration values for Owner Type BDT. {codeListAgencyName}IATA AIDM{/codeListAgencyName}
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MatchTypeCodeContentType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Full"/>
 *     &lt;xs:enumeration value="None"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Partial"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum MatchTypeCodeContentType implements Serializable {
    /** 
     * Full
     */
    FULL("Full"), /** 
                   * None
                   */
    NONE("None"), /** 
                   * Other
                   */
    OTHER("Other"), /** 
                     * Partial
                     */
    PARTIAL("Partial");
    private final String value;

    private MatchTypeCodeContentType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static MatchTypeCodeContentType convert(String value) {
        for (MatchTypeCodeContentType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
