
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Associated order information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OrderRefType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OwnerCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class OrderRefType implements Serializable
{
    private String ownerCode;
    private List<String> serviceIDList = new ArrayList<String>();

    /** 
     * Get the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @return value
     */
    public String getOwnerCode() {
        return ownerCode;
    }

    /** 
     * Set the 'OwnerCode' element value. Airline code assigned to a carrier. Either ICAO-defined 3-character code or IATA-defined 2-character code.
     * 
     * @param ownerCode
     */
    public void setOwnerCode(String ownerCode) {
        this.ownerCode = ownerCode;
    }

    /** 
     * Get the list of 'ServiceID' element items. Uniquely Identifies a Service within the context of one message.
     * 
     * @return list
     */
    public List<String> getServiceIDList() {
        return serviceIDList;
    }

    /** 
     * Set the list of 'ServiceID' element items. Uniquely Identifies a Service within the context of one message.
     * 
     * @param list
     */
    public void setServiceIDList(List<String> list) {
        serviceIDList = list;
    }
}
