
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Passenger Type summary information for an offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTC_OfferParametersType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="PricedPaxNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PTC_PricedCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PTC_RequestedCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="RequestedPaxNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PTCOfferParametersType implements Serializable
{
    private BigDecimal pricedPaxNumber;
    private String PTCPricedCode;
    private String PTCRequestedCode;
    private BigDecimal requestedPaxNumber;

    /** 
     * Get the 'PricedPaxNumber' element value. Number of Passenger(s) for associated passenger type. Example: 2
     * 
     * @return value
     */
    public BigDecimal getPricedPaxNumber() {
        return pricedPaxNumber;
    }

    /** 
     * Set the 'PricedPaxNumber' element value. Number of Passenger(s) for associated passenger type. Example: 2
     * 
     * @param pricedPaxNumber
     */
    public void setPricedPaxNumber(BigDecimal pricedPaxNumber) {
        this.pricedPaxNumber = pricedPaxNumber;
    }

    /** 
     * Get the 'PTC_PricedCode' element value. Actual passenger type code used for pricing.  Example: ADT
     * 
     * @return value
     */
    public String getPTCPricedCode() {
        return PTCPricedCode;
    }

    /** 
     * Set the 'PTC_PricedCode' element value. Actual passenger type code used for pricing.  Example: ADT
     * 
     * @param PTCPricedCode
     */
    public void setPTCPricedCode(String PTCPricedCode) {
        this.PTCPricedCode = PTCPricedCode;
    }

    /** 
     * Get the 'PTC_RequestedCode' element value. Requested passenger type code for pricing. Example: CHD  Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @return value
     */
    public String getPTCRequestedCode() {
        return PTCRequestedCode;
    }

    /** 
     * Set the 'PTC_RequestedCode' element value. Requested passenger type code for pricing. Example: CHD  Encoding scheme: IATA (three character) Passenger Type Code
     * 
     * @param PTCRequestedCode
     */
    public void setPTCRequestedCode(String PTCRequestedCode) {
        this.PTCRequestedCode = PTCRequestedCode;
    }

    /** 
     * Get the 'RequestedPaxNumber' element value. Number of Passenger(s) for associated passenger type. Example: 2
     * 
     * @return value
     */
    public BigDecimal getRequestedPaxNumber() {
        return requestedPaxNumber;
    }

    /** 
     * Set the 'RequestedPaxNumber' element value. Number of Passenger(s) for associated passenger type. Example: 2
     * 
     * @param requestedPaxNumber
     */
    public void setRequestedPaxNumber(BigDecimal requestedPaxNumber) {
        this.requestedPaxNumber = requestedPaxNumber;
    }
}
