
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to a punishment imposed for breaking a law, rule, or contract.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="AppCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="CancelFeeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ChangeFeeInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DescText" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:AmountType" name="PenaltyAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PenaltyID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PercentType" name="PenaltyPercent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PenaltyTypeCodeContentType" name="TypeCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="UpgradeFeeInd" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PenaltyType implements Serializable
{
    private String appCode;
    private Boolean cancelFeeInd;
    private Boolean changeFeeInd;
    private List<String> descTextList = new ArrayList<String>();
    private AmountType penaltyAmount;
    private String penaltyID;
    private PercentType penaltyPercent;
    private PenaltyTypeCodeContentType typeCode;
    private Boolean upgradeFeeInd;

    /** 
     * Get the 'AppCode' element value. Penalty application type. Examples: ADE (After departure) NOS (No show) PDE (Prior to departure)
     * 
     * @return value
     */
    public String getAppCode() {
        return appCode;
    }

    /** 
     * Set the 'AppCode' element value. Penalty application type. Examples: ADE (After departure) NOS (No show) PDE (Prior to departure)
     * 
     * @param appCode
     */
    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    /** 
     * Get the 'CancelFeeInd' element value. When TRUE, Cancellation fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getCancelFeeInd() {
        return cancelFeeInd;
    }

    /** 
     * Set the 'CancelFeeInd' element value. When TRUE, Cancellation fee(s) may apply.
     * 
     * @param cancelFeeInd
     */
    public void setCancelFeeInd(Boolean cancelFeeInd) {
        this.cancelFeeInd = cancelFeeInd;
    }

    /** 
     * Get the 'ChangeFeeInd' element value. When TRUE, Change of Itinerary fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getChangeFeeInd() {
        return changeFeeInd;
    }

    /** 
     * Set the 'ChangeFeeInd' element value. When TRUE, Change of Itinerary fee(s) may apply.
     * 
     * @param changeFeeInd
     */
    public void setChangeFeeInd(Boolean changeFeeInd) {
        this.changeFeeInd = changeFeeInd;
    }

    /** 
     * Get the list of 'DescText' element items. Description of the applicable penalty.
     * 
     * @return list
     */
    public List<String> getDescTextList() {
        return descTextList;
    }

    /** 
     * Set the list of 'DescText' element items. Description of the applicable penalty.
     * 
     * @param list
     */
    public void setDescTextList(List<String> list) {
        descTextList = list;
    }

    /** 
     * Get the 'PenaltyAmount' element value. Penalty monetary value amount and currency code.
     * 
     * @return value
     */
    public AmountType getPenaltyAmount() {
        return penaltyAmount;
    }

    /** 
     * Set the 'PenaltyAmount' element value. Penalty monetary value amount and currency code.
     * 
     * @param penaltyAmount
     */
    public void setPenaltyAmount(AmountType penaltyAmount) {
        this.penaltyAmount = penaltyAmount;
    }

    /** 
     * Get the 'PenaltyID' element value. Unique identifier of the penalty instance.
     * 
     * @return value
     */
    public String getPenaltyID() {
        return penaltyID;
    }

    /** 
     * Set the 'PenaltyID' element value. Unique identifier of the penalty instance.
     * 
     * @param penaltyID
     */
    public void setPenaltyID(String penaltyID) {
        this.penaltyID = penaltyID;
    }

    /** 
     * Get the 'PenaltyPercent' element value. Percentage Value relating to acceptable the total amount by which the Order item price can vary; OR the amount of a penalty.  Example: 20 USD, 2 Percent
     * 
     * @return value
     */
    public PercentType getPenaltyPercent() {
        return penaltyPercent;
    }

    /** 
     * Set the 'PenaltyPercent' element value. Percentage Value relating to acceptable the total amount by which the Order item price can vary; OR the amount of a penalty.  Example: 20 USD, 2 Percent
     * 
     * @param penaltyPercent
     */
    public void setPenaltyPercent(PercentType penaltyPercent) {
        this.penaltyPercent = penaltyPercent;
    }

    /** 
     * Get the 'TypeCode' element value. Penalty type information. Examples: Cancellation, Change, NoShow, Upgrade, Other
     * 
     * @return value
     */
    public PenaltyTypeCodeContentType getTypeCode() {
        return typeCode;
    }

    /** 
     * Set the 'TypeCode' element value. Penalty type information. Examples: Cancellation, Change, NoShow, Upgrade, Other
     * 
     * @param typeCode
     */
    public void setTypeCode(PenaltyTypeCodeContentType typeCode) {
        this.typeCode = typeCode;
    }

    /** 
     * Get the 'UpgradeFeeInd' element value. When TRUE, Upgrade fee(s) may apply.
     * 
     * @return value
     */
    public Boolean getUpgradeFeeInd() {
        return upgradeFeeInd;
    }

    /** 
     * Set the 'UpgradeFeeInd' element value. When TRUE, Upgrade fee(s) may apply.
     * 
     * @param upgradeFeeInd
     */
    public void setUpgradeFeeInd(Boolean upgradeFeeInd) {
        this.upgradeFeeInd = upgradeFeeInd;
    }
}
