
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Natural or physical address used for postal service. May be a building address, airport address, etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PostalAddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="BuildingRoomText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountryName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CountrySubDivisionName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LabelText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PO_BoxCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StreetText" minOccurs="0" maxOccurs="2"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PostalAddressType implements Serializable
{
    private String buildingRoomText;
    private String cityName;
    private String countryCode;
    private String countryName;
    private String countrySubDivisionName;
    private String labelText;
    private String POBoxCode;
    private String postalCode;
    private List<String> streetTextList = new ArrayList<String>();

    /** 
     * Get the 'BuildingRoomText' element value. Additional address information including building name, room, apartment, or suite number.
     * 
     * @return value
     */
    public String getBuildingRoomText() {
        return buildingRoomText;
    }

    /** 
     * Set the 'BuildingRoomText' element value. Additional address information including building name, room, apartment, or suite number.
     * 
     * @param buildingRoomText
     */
    public void setBuildingRoomText(String buildingRoomText) {
        this.buildingRoomText = buildingRoomText;
    }

    /** 
     * Get the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. The name, expressed as text, of the city, town or village.
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'CountryName' element value. The name, expressed as text, of the country.
     * 
     * @return value
     */
    public String getCountryName() {
        return countryName;
    }

    /** 
     * Set the 'CountryName' element value. The name, expressed as text, of the country.
     * 
     * @param countryName
     */
    public void setCountryName(String countryName) {
        this.countryName = countryName;
    }

    /** 
     * Get the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @return value
     */
    public String getCountrySubDivisionName() {
        return countrySubDivisionName;
    }

    /** 
     * Set the 'CountrySubDivisionName' element value. The name, expressed as text, of the sub-division of a country.
     * 
     * @param countrySubDivisionName
     */
    public void setCountrySubDivisionName(String countrySubDivisionName) {
        this.countrySubDivisionName = countrySubDivisionName;
    }

    /** 
     * Get the 'LabelText' element value. Used to differentiate multiple Postal Addresses of one contact.  Examples: AddressAtOrigin or AddressAtDestination
     * 
     * @return value
     */
    public String getLabelText() {
        return labelText;
    }

    /** 
     * Set the 'LabelText' element value. Used to differentiate multiple Postal Addresses of one contact.  Examples: AddressAtOrigin or AddressAtDestination
     * 
     * @param labelText
     */
    public void setLabelText(String labelText) {
        this.labelText = labelText;
    }

    /** 
     * Get the 'PO_BoxCode' element value. Post office box.  Example: P.O. Box 21
     * 
     * @return value
     */
    public String getPOBoxCode() {
        return POBoxCode;
    }

    /** 
     * Set the 'PO_BoxCode' element value. Post office box.  Example: P.O. Box 21
     * 
     * @param POBoxCode
     */
    public void setPOBoxCode(String POBoxCode) {
        this.POBoxCode = POBoxCode;
    }

    /** 
     * Get the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Postal code. Examples: 11001, 11001-2345
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the list of 'StreetText' element items. Street name and number. Examples: Main Street, 100 Main Street
     * 
     * @return list
     */
    public List<String> getStreetTextList() {
        return streetTextList;
    }

    /** 
     * Set the list of 'StreetText' element items. Street name and number. Examples: Main Street, 100 Main Street
     * 
     * @param list
     */
    public void setStreetTextList(List<String> list) {
        streetTextList = list;
    }
}
