
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Price Variance supports specifying Payment Processing Rules, including payment failure. Acceptable amount and/or percentage of the total amount by which the Order item price can vary. Example: 20 USD, 2 Percent
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceVarianceRuleType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AmountType" name="AcceptableVarianceAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PercentType" name="AcceptableVariancePercent" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="EffectivePeriodDuration" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="RuleID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RuleName" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceVarianceRuleType implements Serializable
{
    private AmountType acceptableVarianceAmount;
    private PercentType acceptableVariancePercent;
    private String effectivePeriodDuration;
    private String ownerName;
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private String ruleID;
    private String ruleName;

    /** 
     * Get the 'AcceptableVarianceAmount' element value. Acceptable amount by which the price at time of payment can vary. Example: 20 USD
     * 
     * @return value
     */
    public AmountType getAcceptableVarianceAmount() {
        return acceptableVarianceAmount;
    }

    /** 
     * Set the 'AcceptableVarianceAmount' element value. Acceptable amount by which the price at time of payment can vary. Example: 20 USD
     * 
     * @param acceptableVarianceAmount
     */
    public void setAcceptableVarianceAmount(AmountType acceptableVarianceAmount) {
        this.acceptableVarianceAmount = acceptableVarianceAmount;
    }

    /** 
     * Get the 'AcceptableVariancePercent' element value. Acceptable percent by which the price at time of payment can vary. Example: 2 percent
     * 
     * @return value
     */
    public PercentType getAcceptableVariancePercent() {
        return acceptableVariancePercent;
    }

    /** 
     * Set the 'AcceptableVariancePercent' element value. Acceptable percent by which the price at time of payment can vary. Example: 2 percent
     * 
     * @param acceptableVariancePercent
     */
    public void setAcceptableVariancePercent(
            PercentType acceptableVariancePercent) {
        this.acceptableVariancePercent = acceptableVariancePercent;
    }

    /** 
     * Get the 'EffectivePeriodDuration' element value. Rule Effective Period.
     * 
     * @return value
     */
    public String getEffectivePeriodDuration() {
        return effectivePeriodDuration;
    }

    /** 
     * Set the 'EffectivePeriodDuration' element value. Rule Effective Period.
     * 
     * @param effectivePeriodDuration
     */
    public void setEffectivePeriodDuration(String effectivePeriodDuration) {
        this.effectivePeriodDuration = effectivePeriodDuration;
    }

    /** 
     * Get the 'OwnerName' element value. Entity that owns/ assigned this Rule.  If this is an airline, the IATA Airline Designator Code should be used.
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. Entity that owns/ assigned this Rule.  If this is an airline, the IATA Airline Designator Code should be used.
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'RuleID' element value. Rule ID assigned by the owner. Example: PRICERULE001.
     * 
     * @return value
     */
    public String getRuleID() {
        return ruleID;
    }

    /** 
     * Set the 'RuleID' element value. Rule ID assigned by the owner. Example: PRICERULE001.
     * 
     * @param ruleID
     */
    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    /** 
     * Get the 'RuleName' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @return value
     */
    public String getRuleName() {
        return ruleName;
    }

    /** 
     * Set the 'RuleName' element value. Rule Name. Example: Acceptable Price variance
     * 
     * @param ruleName
     */
    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }
}
