
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Promotion Issuer or Sponsor.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromotionIssuerType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CarrierType" name="Carrier" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrgType" name="Org" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TravelAgencyType" name="TravelAgency" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PromotionIssuerType implements Serializable
{
    private CarrierType carrier;
    private OrgType org;
    private TravelAgencyType travelAgency;

    /** 
     * Get the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @return value
     */
    public CarrierType getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * 
     * @param carrier
     */
    public void setCarrier(CarrierType carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @return value
     */
    public OrgType getOrg() {
        return org;
    }

    /** 
     * Set the 'Org' element value. An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
     * 
     * @param org
     */
    public void setOrg(OrgType org) {
        this.org = org;
    }

    /** 
     * Get the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @return value
     */
    public TravelAgencyType getTravelAgency() {
        return travelAgency;
    }

    /** 
     * Set the 'TravelAgency' element value. A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package tours.
     * 
     * @param travelAgency
     */
    public void setTravelAgency(TravelAgencyType travelAgency) {
        this.travelAgency = travelAgency;
    }
}
