
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information related to publicizing  a product, organization, or venture so as to increase sales or public awareness.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromotionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OwnerName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PaxRefID" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PromotionID" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PromotionIssuerType" name="PromotionIssuer" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RemarkType" name="Remark" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="URL" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PromotionType implements Serializable
{
    private String ownerName;
    private List<String> paxRefIDList = new ArrayList<String>();
    private String promotionID;
    private PromotionIssuerType promotionIssuer;
    private List<RemarkType> remarkList = new ArrayList<RemarkType>();
    private String URL;

    /** 
     * Get the 'OwnerName' element value. Name of the Individual to which this Promotion applies.
     * 
     * @return value
     */
    public String getOwnerName() {
        return ownerName;
    }

    /** 
     * Set the 'OwnerName' element value. Name of the Individual to which this Promotion applies.
     * 
     * @param ownerName
     */
    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    /** 
     * Get the list of 'PaxRefID' element items. Reference to a PaxID.
     * 
     * @return list
     */
    public List<String> getPaxRefIDList() {
        return paxRefIDList;
    }

    /** 
     * Set the list of 'PaxRefID' element items. Reference to a PaxID.
     * 
     * @param list
     */
    public void setPaxRefIDList(List<String> list) {
        paxRefIDList = list;
    }

    /** 
     * Get the 'PromotionID' element value. Promotion code ID or number. Example: PROMO123. Used in conjunction with Link (Promotion URL), Issuer (Promotion Owner or Sponsor) and Remarks (Promotion remarks).
     * 
     * @return value
     */
    public String getPromotionID() {
        return promotionID;
    }

    /** 
     * Set the 'PromotionID' element value. Promotion code ID or number. Example: PROMO123. Used in conjunction with Link (Promotion URL), Issuer (Promotion Owner or Sponsor) and Remarks (Promotion remarks).
     * 
     * @param promotionID
     */
    public void setPromotionID(String promotionID) {
        this.promotionID = promotionID;
    }

    /** 
     * Get the 'PromotionIssuer' element value. Promotion Issuer or Sponsor.
     * 
     * @return value
     */
    public PromotionIssuerType getPromotionIssuer() {
        return promotionIssuer;
    }

    /** 
     * Set the 'PromotionIssuer' element value. Promotion Issuer or Sponsor.
     * 
     * @param promotionIssuer
     */
    public void setPromotionIssuer(PromotionIssuerType promotionIssuer) {
        this.promotionIssuer = promotionIssuer;
    }

    /** 
     * Get the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @return list
     */
    public List<RemarkType> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items. Additional, supplementary information about the document or service.
     * 
     * @param list
     */
    public void setRemarkList(List<RemarkType> list) {
        remarkList = list;
    }

    /** 
     * Get the 'URL' element value. Promotion URL. Example: http://promos.site.com
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' element value. Promotion URL. Example: http://promos.site.com
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }
}
