
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * Results of the OrderReshop request including reshopped Offers or repriced Offer.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReshopResultsType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:boolean" name="NoPriceChangeInd" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:RepricedOfferType" name="RepricedOffer" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ReshopOffersType" name="ReshopOffers" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReshopResultsType implements Serializable
{
    private int choiceSelect = -1;
    private static final int NO_PRICE_CHANGE_IND_CHOICE = 0;
    private static final int REPRICED_OFFER_CHOICE = 1;
    private static final int RESHOP_OFFERS_CHOICE = 2;
    private boolean noPriceChangeInd;
    private RepricedOfferType repricedOffer;
    private ReshopOffersType reshopOffers;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if NoPriceChangeInd is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifNoPriceChangeInd() {
        return choiceSelect == NO_PRICE_CHANGE_IND_CHOICE;
    }

    /** 
     * Get the 'NoPriceChangeInd' element value.
     * 
     * @return value
     */
    public boolean isNoPriceChangeInd() {
        return noPriceChangeInd;
    }

    /** 
     * Set the 'NoPriceChangeInd' element value.
     * 
     * @param noPriceChangeInd
     */
    public void setNoPriceChangeInd(boolean noPriceChangeInd) {
        setChoiceSelect(NO_PRICE_CHANGE_IND_CHOICE);
        this.noPriceChangeInd = noPriceChangeInd;
    }

    /** 
     * Check if RepricedOffer is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifRepricedOffer() {
        return choiceSelect == REPRICED_OFFER_CHOICE;
    }

    /** 
     * Get the 'RepricedOffer' element value. Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
     * 
     * @return value
     */
    public RepricedOfferType getRepricedOffer() {
        return repricedOffer;
    }

    /** 
     * Set the 'RepricedOffer' element value. Function used to request the repricing of an existing Order, possibly as a consequence of expired TimeLimits. Airline returns Offers/OfferItems that describe the changes incurred from the reprice request.
     * 
     * @param repricedOffer
     */
    public void setRepricedOffer(RepricedOfferType repricedOffer) {
        setChoiceSelect(REPRICED_OFFER_CHOICE);
        this.repricedOffer = repricedOffer;
    }

    /** 
     * Check if ReshopOffers is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReshopOffers() {
        return choiceSelect == RESHOP_OFFERS_CHOICE;
    }

    /** 
     * Get the 'ReshopOffers' element value. Reshopped Carrier Offers.
     * 
     * @return value
     */
    public ReshopOffersType getReshopOffers() {
        return reshopOffers;
    }

    /** 
     * Set the 'ReshopOffers' element value. Reshopped Carrier Offers.
     * 
     * @param reshopOffers
     */
    public void setReshopOffers(ReshopOffersType reshopOffers) {
        setChoiceSelect(RESHOP_OFFERS_CHOICE);
        this.reshopOffers = reshopOffers;
    }
}
