
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * ServiceList response information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResponseType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:PenaltyRefType" name="ChangeFees" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:CommissionType" name="Commission" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:DataListsType" name="DataLists" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MarketingMessageType" name="MarketingMessage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MetadataType" name="Metadata" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:OrderReshopProcessingType" name="OrderReshopProcessing" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaxGroupType" name="PaxGroup" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:PaymentInfoType" name="PaymentInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ReshopResultsType" name="ReshopResults" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ShoppingResponseType" name="ShoppingResponse" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:WarningType" name="Warning" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ResponseType implements Serializable
{
    private PenaltyRefType changeFees;
    private CommissionType commission;
    private DataListsType dataLists;
    private MarketingMessageType marketingMessage;
    private MetadataType metadata;
    private OrderReshopProcessingType orderReshopProcessing;
    private PaxGroupType paxGroup;
    private List<PaymentInfoType> paymentInfoList = new ArrayList<PaymentInfoType>();
    private ReshopResultsType reshopResults;
    private ShoppingResponseType shoppingResponse;
    private List<WarningType> warningList = new ArrayList<WarningType>();

    /** 
     * Get the 'ChangeFees' element value. Information related to a punishment imposed for breaking a law, rule, or contract.
     * 
     * @return value
     */
    public PenaltyRefType getChangeFees() {
        return changeFees;
    }

    /** 
     * Set the 'ChangeFees' element value. Information related to a punishment imposed for breaking a law, rule, or contract.
     * 
     * @param changeFees
     */
    public void setChangeFees(PenaltyRefType changeFees) {
        this.changeFees = changeFees;
    }

    /** 
     * Get the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @return value
     */
    public CommissionType getCommission() {
        return commission;
    }

    /** 
     * Set the 'Commission' element value. An amount of money, typically a set percentage of the value involved, paid to an agent in a commercial transaction.
     * 
     * @param commission
     */
    public void setCommission(CommissionType commission) {
        this.commission = commission;
    }

    /** 
     * Get the 'DataLists' element value. Data List definition for this message.
     * 
     * @return value
     */
    public DataListsType getDataLists() {
        return dataLists;
    }

    /** 
     * Set the 'DataLists' element value. Data List definition for this message.
     * 
     * @param dataLists
     */
    public void setDataLists(DataListsType dataLists) {
        this.dataLists = dataLists;
    }

    /** 
     * Get the 'MarketingMessage' element value. Additional, supplementary information about the document or service.
     * 
     * @return value
     */
    public MarketingMessageType getMarketingMessage() {
        return marketingMessage;
    }

    /** 
     * Set the 'MarketingMessage' element value. Additional, supplementary information about the document or service.
     * 
     * @param marketingMessage
     */
    public void setMarketingMessage(MarketingMessageType marketingMessage) {
        this.marketingMessage = marketingMessage;
    }

    /** 
     * Get the 'Metadata' element value. Message wide metadata information.
     * 
     * @return value
     */
    public MetadataType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value. Message wide metadata information.
     * 
     * @param metadata
     */
    public void setMetadata(MetadataType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'OrderReshopProcessing' element value. Marketing messages for Order Reshop.
     * 
     * @return value
     */
    public OrderReshopProcessingType getOrderReshopProcessing() {
        return orderReshopProcessing;
    }

    /** 
     * Set the 'OrderReshopProcessing' element value. Marketing messages for Order Reshop.
     * 
     * @param orderReshopProcessing
     */
    public void setOrderReshopProcessing(
            OrderReshopProcessingType orderReshopProcessing) {
        this.orderReshopProcessing = orderReshopProcessing;
    }

    /** 
     * Get the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @return value
     */
    public PaxGroupType getPaxGroup() {
        return paxGroup;
    }

    /** 
     * Set the 'PaxGroup' element value. A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency.
     * 
     * @param paxGroup
     */
    public void setPaxGroup(PaxGroupType paxGroup) {
        this.paxGroup = paxGroup;
    }

    /** 
     * Get the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @return list
     */
    public List<PaymentInfoType> getPaymentInfoList() {
        return paymentInfoList;
    }

    /** 
     * Set the list of 'PaymentInfo' element items. Information related to the settlement of a transaction through monetary or other compensations. For example, a payment may be applied to an entire Order or individual Order Items.
     * 
     * @param list
     */
    public void setPaymentInfoList(List<PaymentInfoType> list) {
        paymentInfoList = list;
    }

    /** 
     * Get the 'ReshopResults' element value. Results of the OrderReshop request including reshopped Offers or repriced Offer.
     * 
     * @return value
     */
    public ReshopResultsType getReshopResults() {
        return reshopResults;
    }

    /** 
     * Set the 'ReshopResults' element value. Results of the OrderReshop request including reshopped Offers or repriced Offer.
     * 
     * @param reshopResults
     */
    public void setReshopResults(ReshopResultsType reshopResults) {
        this.reshopResults = reshopResults;
    }

    /** 
     * Get the 'ShoppingResponse' element value. Facilitates the tracking of what was Offered and contains an identifier unique to the source Airline for a set of product Offers returned in response to a shopping request.
     * 
     * @return value
     */
    public ShoppingResponseType getShoppingResponse() {
        return shoppingResponse;
    }

    /** 
     * Set the 'ShoppingResponse' element value. Facilitates the tracking of what was Offered and contains an identifier unique to the source Airline for a set of product Offers returned in response to a shopping request.
     * 
     * @param shoppingResponse
     */
    public void setShoppingResponse(ShoppingResponseType shoppingResponse) {
        this.shoppingResponse = shoppingResponse;
    }

    /** 
     * Get the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @return list
     */
    public List<WarningType> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items. Contains information related to potential business errors detected during processing of the preceding request.
     * 
     * @param list
     */
    public void setWarningList(List<WarningType> list) {
        warningList = list;
    }
}
