
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * The Seat Location selected by the Passenger (via SeatAvailability) or assigned tot he Passenger by the Airline for a given segment. When used, only a single Passenger must be referenced within the Service.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatAssignmentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DatedOperatingLegRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:SeatType" name="Seat" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceDefinitionRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatAssignmentType implements Serializable
{
    private String datedOperatingLegRefID;
    private SeatType seat;
    private String serviceDefinitionRefID;

    /** 
     * Get the 'DatedOperatingLegRefID' element value. Reference to a Dated Operating Leg ID within this message.
     * 
     * @return value
     */
    public String getDatedOperatingLegRefID() {
        return datedOperatingLegRefID;
    }

    /** 
     * Set the 'DatedOperatingLegRefID' element value. Reference to a Dated Operating Leg ID within this message.
     * 
     * @param datedOperatingLegRefID
     */
    public void setDatedOperatingLegRefID(String datedOperatingLegRefID) {
        this.datedOperatingLegRefID = datedOperatingLegRefID;
    }

    /** 
     * Get the 'Seat' element value. A sitting place for a passenger located in the cabin.
     * 
     * @return value
     */
    public SeatType getSeat() {
        return seat;
    }

    /** 
     * Set the 'Seat' element value. A sitting place for a passenger located in the cabin.
     * 
     * @param seat
     */
    public void setSeat(SeatType seat) {
        this.seat = seat;
    }

    /** 
     * Get the 'ServiceDefinitionRefID' element value. Reference to a Service Definition ID within this message.
     * 
     * @return value
     */
    public String getServiceDefinitionRefID() {
        return serviceDefinitionRefID;
    }

    /** 
     * Set the 'ServiceDefinitionRefID' element value. Reference to a Service Definition ID within this message.
     * 
     * @param serviceDefinitionRefID
     */
    public void setServiceDefinitionRefID(String serviceDefinitionRefID) {
        this.serviceDefinitionRefID = serviceDefinitionRefID;
    }
}
