
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Airline defined characteristics shared by a group of seats.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CharacteristicCode" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:DescType" name="MarketingInfo" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:KeyValuePropertyType" name="SeatKeywords" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:MeasureType" name="SeatPitchMeasure" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="SeatProfileID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:MeasureType" name="SeatWidthMeasure" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatProfileType implements Serializable
{
    private List<String> characteristicCodeList = new ArrayList<String>();
    private List<DescType> marketingInfoList = new ArrayList<DescType>();
    private List<KeyValuePropertyType> seatKeywordList = new ArrayList<KeyValuePropertyType>();
    private MeasureType seatPitchMeasure;
    private String seatProfileID;
    private MeasureType seatWidthMeasure;

    /** 
     * Get the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @return list
     */
    public List<String> getCharacteristicCodeList() {
        return characteristicCodeList;
    }

    /** 
     * Set the list of 'CharacteristicCode' element items. Seat characteristic/property code (e.g. A - Aisle Seat, W - Window Seat, etc.).
     * 
     * @param list
     */
    public void setCharacteristicCodeList(List<String> list) {
        characteristicCodeList = list;
    }

    /** 
     * Get the list of 'MarketingInfo' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @return list
     */
    public List<DescType> getMarketingInfoList() {
        return marketingInfoList;
    }

    /** 
     * Set the list of 'MarketingInfo' element items. An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
     * 
     * @param list
     */
    public void setMarketingInfoList(List<DescType> list) {
        marketingInfoList = list;
    }

    /** 
     * Get the list of 'SeatKeywords' element items. Key value pair used by airlines to further describe seat characteristics.
     * 
     * @return list
     */
    public List<KeyValuePropertyType> getSeatKeywordList() {
        return seatKeywordList;
    }

    /** 
     * Set the list of 'SeatKeywords' element items. Key value pair used by airlines to further describe seat characteristics.
     * 
     * @param list
     */
    public void setSeatKeywordList(List<KeyValuePropertyType> list) {
        seatKeywordList = list;
    }

    /** 
     * Get the 'SeatPitchMeasure' element value. Measure of a given seat's pitch.
     * 
     * @return value
     */
    public MeasureType getSeatPitchMeasure() {
        return seatPitchMeasure;
    }

    /** 
     * Set the 'SeatPitchMeasure' element value. Measure of a given seat's pitch.
     * 
     * @param seatPitchMeasure
     */
    public void setSeatPitchMeasure(MeasureType seatPitchMeasure) {
        this.seatPitchMeasure = seatPitchMeasure;
    }

    /** 
     * Get the 'SeatProfileID' element value. Unique identifier associated to this Seat Profile.
     * 
     * @return value
     */
    public String getSeatProfileID() {
        return seatProfileID;
    }

    /** 
     * Set the 'SeatProfileID' element value. Unique identifier associated to this Seat Profile.
     * 
     * @param seatProfileID
     */
    public void setSeatProfileID(String seatProfileID) {
        this.seatProfileID = seatProfileID;
    }

    /** 
     * Get the 'SeatWidthMeasure' element value. Measure of a given seat's width.
     * 
     * @return value
     */
    public MeasureType getSeatWidthMeasure() {
        return seatWidthMeasure;
    }

    /** 
     * Set the 'SeatWidthMeasure' element value. Measure of a given seat's width.
     * 
     * @param seatWidthMeasure
     */
    public void setSeatWidthMeasure(MeasureType seatWidthMeasure) {
        this.seatWidthMeasure = seatWidthMeasure;
    }
}
