
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;

/** 
 * The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Service1Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DateTimeType" name="InventoryGuaranteeTimeLimitDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ServiceDefinitionRefID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceID" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ServiceRefID" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Service1Type implements Serializable
{
    private DateTimeType inventoryGuaranteeTimeLimitDateTime;
    private String serviceDefinitionRefID;
    private String serviceID;
    private String serviceRefID;

    /** 
     * Get the 'InventoryGuaranteeTimeLimitDateTime' element value. The length of time inventory against a given Service is guaranteed.  If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed.   Notes:  The presence of an inventory guarantee does not assume a guarantee of price.  For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present.  The assumption is that inventory is held when an Order is created (or changed), so this time limit only applies in the context of an Offer.
     * 
     * @return value
     */
    public DateTimeType getInventoryGuaranteeTimeLimitDateTime() {
        return inventoryGuaranteeTimeLimitDateTime;
    }

    /** 
     * Set the 'InventoryGuaranteeTimeLimitDateTime' element value. The length of time inventory against a given Service is guaranteed.  If inventory is not guaranteed, the Order creation (or change) may fail. In the absence of a time limit, no inventory is guaranteed.   Notes:  The presence of an inventory guarantee does not assume a guarantee of price.  For the price to be guaranteed against a given Offer Item, the Price Guarantee Time Limit must also be present.  The assumption is that inventory is held when an Order is created (or changed), so this time limit only applies in the context of an Offer.
     * 
     * @param inventoryGuaranteeTimeLimitDateTime
     */
    public void setInventoryGuaranteeTimeLimitDateTime(
            DateTimeType inventoryGuaranteeTimeLimitDateTime) {
        this.inventoryGuaranteeTimeLimitDateTime = inventoryGuaranteeTimeLimitDateTime;
    }

    /** 
     * Get the 'ServiceDefinitionRefID' element value. Reference to a service definition.
     * 
     * @return value
     */
    public String getServiceDefinitionRefID() {
        return serviceDefinitionRefID;
    }

    /** 
     * Set the 'ServiceDefinitionRefID' element value. Reference to a service definition.
     * 
     * @param serviceDefinitionRefID
     */
    public void setServiceDefinitionRefID(String serviceDefinitionRefID) {
        this.serviceDefinitionRefID = serviceDefinitionRefID;
    }

    /** 
     * Get the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @return value
     */
    public String getServiceID() {
        return serviceID;
    }

    /** 
     * Set the 'ServiceID' element value. Uniquely Identifies a Service within the context of one message.
     * 
     * @param serviceID
     */
    public void setServiceID(String serviceID) {
        this.serviceID = serviceID;
    }

    /** 
     * Get the 'ServiceRefID' element value. Reference to another service instance.
     * 
     * @return value
     */
    public String getServiceRefID() {
        return serviceRefID;
    }

    /** 
     * Set the 'ServiceRefID' element value. Reference to another service instance.
     * 
     * @param serviceRefID
     */
    public void setServiceRefID(String serviceRefID) {
        this.serviceRefID = serviceRefID;
    }
}
