
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * References to the details of this Service.  May include either Passenger Journeys, a Service Definition, or a Selected Seat.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceAssociationsType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="PaxJourneyRefID" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SeatAssignmentType" name="SeatAssignment" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="ns:ServiceDefinitionRefType" name="ServiceDefinitionRef" minOccurs="1" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ServiceAssociationsType implements Serializable
{
    private int choiceSelect = -1;
    private static final int PAX_JOURNEY_REF_ID_LIST_CHOICE = 0;
    private static final int SEAT_ASSIGNMENT_CHOICE = 1;
    private static final int SERVICE_DEFINITION_REF_CHOICE = 2;
    private List<String> paxJourneyRefIDList = new ArrayList<String>();
    private SeatAssignmentType seatAssignment;
    private ServiceDefinitionRefType serviceDefinitionRef;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if PaxJourneyRefIDList is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPaxJourneyRefIDList() {
        return choiceSelect == PAX_JOURNEY_REF_ID_LIST_CHOICE;
    }

    /** 
     * Get the list of 'PaxJourneyRefID' element items. Reference to one Journey in the Datalists that are being sold as part of this OfferItem/Service.
     * 
     * @return list
     */
    public List<String> getPaxJourneyRefIDList() {
        return paxJourneyRefIDList;
    }

    /** 
     * Set the list of 'PaxJourneyRefID' element items. Reference to one Journey in the Datalists that are being sold as part of this OfferItem/Service.
     * 
     * @param list
     */
    public void setPaxJourneyRefIDList(List<String> list) {
        setChoiceSelect(PAX_JOURNEY_REF_ID_LIST_CHOICE);
        paxJourneyRefIDList = list;
    }

    /** 
     * Check if SeatAssignment is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifSeatAssignment() {
        return choiceSelect == SEAT_ASSIGNMENT_CHOICE;
    }

    /** 
     * Get the 'SeatAssignment' element value. The Seat Location selected by the Passenger (via SeatAvailability) or assigned tot he Passenger by the Airline for a given segment. When used, only a single Passenger must be referenced within the Service.
     * 
     * @return value
     */
    public SeatAssignmentType getSeatAssignment() {
        return seatAssignment;
    }

    /** 
     * Set the 'SeatAssignment' element value. The Seat Location selected by the Passenger (via SeatAvailability) or assigned tot he Passenger by the Airline for a given segment. When used, only a single Passenger must be referenced within the Service.
     * 
     * @param seatAssignment
     */
    public void setSeatAssignment(SeatAssignmentType seatAssignment) {
        setChoiceSelect(SEAT_ASSIGNMENT_CHOICE);
        this.seatAssignment = seatAssignment;
    }

    /** 
     * Check if ServiceDefinitionRef is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifServiceDefinitionRef() {
        return choiceSelect == SERVICE_DEFINITION_REF_CHOICE;
    }

    /** 
     * Get the 'ServiceDefinitionRef' element value. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @return value
     */
    public ServiceDefinitionRefType getServiceDefinitionRef() {
        return serviceDefinitionRef;
    }

    /** 
     * Set the 'ServiceDefinitionRef' element value. Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
     * 
     * @param serviceDefinitionRef
     */
    public void setServiceDefinitionRef(
            ServiceDefinitionRefType serviceDefinitionRef) {
        setChoiceSelect(SERVICE_DEFINITION_REF_CHOICE);
        this.serviceDefinitionRef = serviceDefinitionRef;
    }
}
