
package com.gridnine.xtrip.server.gds.s7ndc.wsmodel052.orderReshop.rs;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Tax summary information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.iata.org/IATA/2015/00/2019.1/IATA_OrderReshopRS" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxSummaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:boolean" name="AllRefundableInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="ApproximateInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="CollectionInd" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RefundMethodText" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:TaxType" name="Tax" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AmountType" name="TotalRefundableTaxAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:AmountType" name="TotalTaxAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TaxSummaryType implements Serializable
{
    private Boolean allRefundableInd;
    private Boolean approximateInd;
    private Boolean collectionInd;
    private String refundMethodText;
    private List<TaxType> taxList = new ArrayList<TaxType>();
    private AmountType totalRefundableTaxAmount;
    private AmountType totalTaxAmount;

    /** 
     * Get the 'AllRefundableInd' element value. When true, all tax breakdown amounts are refundable.
     * 
     * @return value
     */
    public Boolean getAllRefundableInd() {
        return allRefundableInd;
    }

    /** 
     * Set the 'AllRefundableInd' element value. When true, all tax breakdown amounts are refundable.
     * 
     * @param allRefundableInd
     */
    public void setAllRefundableInd(Boolean allRefundableInd) {
        this.allRefundableInd = allRefundableInd;
    }

    /** 
     * Get the 'ApproximateInd' element value. When true, this tax is approximate.
     * 
     * @return value
     */
    public Boolean getApproximateInd() {
        return approximateInd;
    }

    /** 
     * Set the 'ApproximateInd' element value. When true, this tax is approximate.
     * 
     * @param approximateInd
     */
    public void setApproximateInd(Boolean approximateInd) {
        this.approximateInd = approximateInd;
    }

    /** 
     * Get the 'CollectionInd' element value. When true, all specified tax breakdowns must be collected.
     * 
     * @return value
     */
    public Boolean getCollectionInd() {
        return collectionInd;
    }

    /** 
     * Set the 'CollectionInd' element value. When true, all specified tax breakdowns must be collected.
     * 
     * @param collectionInd
     */
    public void setCollectionInd(Boolean collectionInd) {
        this.collectionInd = collectionInd;
    }

    /** 
     * Get the 'RefundMethodText' element value. Information from the Airline detailing to the Customer how the tax refund will be processed and what the Customer has to do for the refund.
     * 
     * @return value
     */
    public String getRefundMethodText() {
        return refundMethodText;
    }

    /** 
     * Set the 'RefundMethodText' element value. Information from the Airline detailing to the Customer how the tax refund will be processed and what the Customer has to do for the refund.
     * 
     * @param refundMethodText
     */
    public void setRefundMethodText(String refundMethodText) {
        this.refundMethodText = refundMethodText;
    }

    /** 
     * Get the list of 'Tax' element items. A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
     * 
     * @return list
     */
    public List<TaxType> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items. A compulsory contribution to state revenue, levied by the government on workers' income and business profits or added to the cost of some goods, services, and transactions.
     * 
     * @param list
     */
    public void setTaxList(List<TaxType> list) {
        taxList = list;
    }

    /** 
     * Get the 'TotalRefundableTaxAmount' element value. The total amount of all refundable taxes as calculated by the Airline.
     * 
     * @return value
     */
    public AmountType getTotalRefundableTaxAmount() {
        return totalRefundableTaxAmount;
    }

    /** 
     * Set the 'TotalRefundableTaxAmount' element value. The total amount of all refundable taxes as calculated by the Airline.
     * 
     * @param totalRefundableTaxAmount
     */
    public void setTotalRefundableTaxAmount(AmountType totalRefundableTaxAmount) {
        this.totalRefundableTaxAmount = totalRefundableTaxAmount;
    }

    /** 
     * Get the 'TotalTaxAmount' element value. Total of all applicable tax amounts included in the price.  If tax breakdowns are provided, this amount should match the sum of the tax breakdown amounts.
     * 
     * @return value
     */
    public AmountType getTotalTaxAmount() {
        return totalTaxAmount;
    }

    /** 
     * Set the 'TotalTaxAmount' element value. Total of all applicable tax amounts included in the price.  If tax breakdowns are provided, this amount should match the sum of the tax breakdown amounts.
     * 
     * @param totalTaxAmount
     */
    public void setTotalTaxAmount(AmountType totalTaxAmount) {
        this.totalTaxAmount = totalTaxAmount;
    }
}
